<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationInformationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Origin and Destination location, and time information for the request. Also includes the ability to specify a connection location for the search.
 * @subpackage Structs
 */
class OriginDestinationInformationType extends TravelDateTimeType
{
    /**
     * The OriginLocation
     * @var \Sabre\OTAPing\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * @var \Sabre\OTAPing\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The ConnectionLocations
     * Meta informations extracted from the WSDL
     * - documentation: Travel Connection Location - for example, air uses the IATA 3 letter code.
     * - minOccurs: 0
     * @var mixed
     */
    public $ConnectionLocations;
    /**
     * Constructor method for OriginDestinationInformationType
     * @uses OriginDestinationInformationType::setOriginLocation()
     * @uses OriginDestinationInformationType::setDestinationLocation()
     * @uses OriginDestinationInformationType::setConnectionLocations()
     * @param \Sabre\OTAPing\Structs\OriginLocation $originLocation
     * @param \Sabre\OTAPing\Structs\DestinationLocation $destinationLocation
     * @param mixed $connectionLocations
     */
    public function __construct(\Sabre\OTAPing\Structs\OriginLocation $originLocation = null, \Sabre\OTAPing\Structs\DestinationLocation $destinationLocation = null, $connectionLocations = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation)
            ->setConnectionLocations($connectionLocations);
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\OTAPing\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\OTAPing\Structs\OriginLocation $originLocation
     * @return \Sabre\OTAPing\Structs\OriginDestinationInformationType
     */
    public function setOriginLocation(\Sabre\OTAPing\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\OTAPing\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\OTAPing\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\OTAPing\Structs\OriginDestinationInformationType
     */
    public function setDestinationLocation(\Sabre\OTAPing\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get ConnectionLocations value
     * @return mixed|null
     */
    public function getConnectionLocations()
    {
        return $this->ConnectionLocations;
    }
    /**
     * Set ConnectionLocations value
     * @param mixed $connectionLocations
     * @return \Sabre\OTAPing\Structs\OriginDestinationInformationType
     */
    public function setConnectionLocations($connectionLocations = null)
    {
        $this->ConnectionLocations = $connectionLocations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\OriginDestinationInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
