<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order Structs
 * Meta informations extracted from the WSDL
 * - documentation: Information pertaining to a specific order.
 * @subpackage Structs
 */
class Order extends AbstractStructBase
{
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Products
     */
    public $Products;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the type of order.
     * - use: optional
     * @var string
     */
    public $OrderType;
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - documentation: The identification number associated to the orders.
     * - use: optional
     * @var string
     */
    public $OrderID;
    /**
     * The ListOfRecipientRPH
     * Meta informations extracted from the WSDL
     * - documentation: The recipient(s) to whom the order pertains.
     * - use: optional
     * @var string
     */
    public $ListOfRecipientRPH;
    /**
     * Constructor method for Order
     * @uses Order::setProducts()
     * @uses Order::setOrderType()
     * @uses Order::setOrderID()
     * @uses Order::setListOfRecipientRPH()
     * @param \Sabre\OTAPing\Structs\Products $products
     * @param string $orderType
     * @param string $orderID
     * @param string $listOfRecipientRPH
     */
    public function __construct(\Sabre\OTAPing\Structs\Products $products = null, $orderType = null, $orderID = null, $listOfRecipientRPH = null)
    {
        $this
            ->setProducts($products)
            ->setOrderType($orderType)
            ->setOrderID($orderID)
            ->setListOfRecipientRPH($listOfRecipientRPH);
    }
    /**
     * Get Products value
     * @return \Sabre\OTAPing\Structs\Products|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \Sabre\OTAPing\Structs\Products $products
     * @return \Sabre\OTAPing\Structs\Order
     */
    public function setProducts(\Sabre\OTAPing\Structs\Products $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get OrderType value
     * @return string|null
     */
    public function getOrderType()
    {
        return $this->OrderType;
    }
    /**
     * Set OrderType value
     * @param string $orderType
     * @return \Sabre\OTAPing\Structs\Order
     */
    public function setOrderType($orderType = null)
    {
        $this->OrderType = $orderType;
        return $this;
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \Sabre\OTAPing\Structs\Order
     */
    public function setOrderID($orderID = null)
    {
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get ListOfRecipientRPH value
     * @return string|null
     */
    public function getListOfRecipientRPH()
    {
        return $this->ListOfRecipientRPH;
    }
    /**
     * Set ListOfRecipientRPH value
     * @param string $listOfRecipientRPH
     * @return \Sabre\OTAPing\Structs\Order
     */
    public function setListOfRecipientRPH($listOfRecipientRPH = null)
    {
        $this->ListOfRecipientRPH = $listOfRecipientRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\Order
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
