<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OTA_PingRS Structs
 * Meta informations extracted from the WSDL
 * - documentation: The OTA_PingRS message is a response to a client message used for testing application connectivity. Specific text sent by the client is to be echoed back in this response.
 * @subpackage Structs
 */
class OTA_PingRS extends AbstractStructBase
{
    /**
     * The Success
     * @var \Sabre\OTAPing\Structs\SuccessType
     */
    public $Success;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\WarningsType
     */
    public $Warnings;
    /**
     * The EchoData
     * Meta informations extracted from the WSDL
     * - documentation: The free-text data that is to be echoed back.
     * @var string
     */
    public $EchoData;
    /**
     * The Errors
     * @var \Sabre\OTAPing\Structs\ErrorsType
     */
    public $Errors;
    /**
     * The EchoToken
     * @var string
     */
    public $EchoToken;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * The Target
     * @var string
     */
    public $Target;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The TransactionIdentifier
     * @var string
     */
    public $TransactionIdentifier;
    /**
     * The SequenceNmbr
     * @var int
     */
    public $SequenceNmbr;
    /**
     * The TransactionStatusCode
     * @var string
     */
    public $TransactionStatusCode;
    /**
     * The RetransmissionIndicator
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The CorrelationID
     * @var string
     */
    public $CorrelationID;
    /**
     * Constructor method for OTA_PingRS
     * @uses OTA_PingRS::setSuccess()
     * @uses OTA_PingRS::setWarnings()
     * @uses OTA_PingRS::setEchoData()
     * @uses OTA_PingRS::setErrors()
     * @uses OTA_PingRS::setEchoToken()
     * @uses OTA_PingRS::setTimeStamp()
     * @uses OTA_PingRS::setTarget()
     * @uses OTA_PingRS::setVersion()
     * @uses OTA_PingRS::setTransactionIdentifier()
     * @uses OTA_PingRS::setSequenceNmbr()
     * @uses OTA_PingRS::setTransactionStatusCode()
     * @uses OTA_PingRS::setRetransmissionIndicator()
     * @uses OTA_PingRS::setCorrelationID()
     * @param \Sabre\OTAPing\Structs\SuccessType $success
     * @param \Sabre\OTAPing\Structs\WarningsType $warnings
     * @param string $echoData
     * @param \Sabre\OTAPing\Structs\ErrorsType $errors
     * @param string $echoToken
     * @param string $timeStamp
     * @param string $target
     * @param string $version
     * @param string $transactionIdentifier
     * @param int $sequenceNmbr
     * @param string $transactionStatusCode
     * @param bool $retransmissionIndicator
     * @param string $correlationID
     */
    public function __construct(\Sabre\OTAPing\Structs\SuccessType $success = null, \Sabre\OTAPing\Structs\WarningsType $warnings = null, $echoData = null, \Sabre\OTAPing\Structs\ErrorsType $errors = null, $echoToken = null, $timeStamp = null, $target = null, $version = null, $transactionIdentifier = null, $sequenceNmbr = null, $transactionStatusCode = null, $retransmissionIndicator = null, $correlationID = null)
    {
        $this
            ->setSuccess($success)
            ->setWarnings($warnings)
            ->setEchoData($echoData)
            ->setErrors($errors)
            ->setEchoToken($echoToken)
            ->setTimeStamp($timeStamp)
            ->setTarget($target)
            ->setVersion($version)
            ->setTransactionIdentifier($transactionIdentifier)
            ->setSequenceNmbr($sequenceNmbr)
            ->setTransactionStatusCode($transactionStatusCode)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setCorrelationID($correlationID);
    }
    /**
     * Get Success value
     * @return \Sabre\OTAPing\Structs\SuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \Sabre\OTAPing\Structs\SuccessType $success
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setSuccess(\Sabre\OTAPing\Structs\SuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \Sabre\OTAPing\Structs\WarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \Sabre\OTAPing\Structs\WarningsType $warnings
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setWarnings(\Sabre\OTAPing\Structs\WarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get EchoData value
     * @return string|null
     */
    public function getEchoData()
    {
        return $this->EchoData;
    }
    /**
     * Set EchoData value
     * @param string $echoData
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setEchoData($echoData = null)
    {
        $this->EchoData = $echoData;
        return $this;
    }
    /**
     * Get Errors value
     * @return \Sabre\OTAPing\Structs\ErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \Sabre\OTAPing\Structs\ErrorsType $errors
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setErrors(\Sabre\OTAPing\Structs\ErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get EchoToken value
     * @return string|null
     */
    public function getEchoToken()
    {
        return $this->EchoToken;
    }
    /**
     * Set EchoToken value
     * @param string $echoToken
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setEchoToken($echoToken = null)
    {
        $this->EchoToken = $echoToken;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setTimeStamp($timeStamp = null)
    {
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Get Target value
     * @return string|null
     */
    public function getTarget()
    {
        return $this->Target;
    }
    /**
     * Set Target value
     * @param string $target
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setTarget($target = null)
    {
        $this->Target = $target;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setVersion($version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get TransactionIdentifier value
     * @return string|null
     */
    public function getTransactionIdentifier()
    {
        return $this->TransactionIdentifier;
    }
    /**
     * Set TransactionIdentifier value
     * @param string $transactionIdentifier
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setTransactionIdentifier($transactionIdentifier = null)
    {
        $this->TransactionIdentifier = $transactionIdentifier;
        return $this;
    }
    /**
     * Get SequenceNmbr value
     * @return int|null
     */
    public function getSequenceNmbr()
    {
        return $this->SequenceNmbr;
    }
    /**
     * Set SequenceNmbr value
     * @param int $sequenceNmbr
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setSequenceNmbr($sequenceNmbr = null)
    {
        $this->SequenceNmbr = $sequenceNmbr;
        return $this;
    }
    /**
     * Get TransactionStatusCode value
     * @return string|null
     */
    public function getTransactionStatusCode()
    {
        return $this->TransactionStatusCode;
    }
    /**
     * Set TransactionStatusCode value
     * @param string $transactionStatusCode
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setTransactionStatusCode($transactionStatusCode = null)
    {
        $this->TransactionStatusCode = $transactionStatusCode;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get CorrelationID value
     * @return string|null
     */
    public function getCorrelationID()
    {
        return $this->CorrelationID;
    }
    /**
     * Set CorrelationID value
     * @param string $correlationID
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function setCorrelationID($correlationID = null)
    {
        $this->CorrelationID = $correlationID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
