<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemSearchCriterionType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Identifies the criterion for a search.
 * @subpackage Structs
 */
class ItemSearchCriterionType extends AbstractStructBase
{
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Position
     */
    public $Position;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Address
     */
    public $Address;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Telephone
     */
    public $Telephone;
    /**
     * The RefPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 999
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\RefPoint[]
     */
    public $RefPoint;
    /**
     * The CodeRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\CodeRef
     */
    public $CodeRef;
    /**
     * The HotelRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\HotelRef[]
     */
    public $HotelRef;
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Radius
     */
    public $Radius;
    /**
     * The MapArea
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\MapArea
     */
    public $MapArea;
    /**
     * The ExactMatch
     * Meta informations extracted from the WSDL
     * - documentation: Values of "true" or "false", indicating whether the string of the search value must be an exact match.
     * - use: optional
     * @var bool
     */
    public $ExactMatch;
    /**
     * The ImportanceType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ImportanceType;
    /**
     * The Ranking
     * Meta informations extracted from the WSDL
     * - documentation: Defines a ranking scale expressed as integers; meaning and scale are based on individual implementations.
     * - use: optional
     * @var int
     */
    public $Ranking;
    /**
     * Constructor method for ItemSearchCriterionType
     * @uses ItemSearchCriterionType::setPosition()
     * @uses ItemSearchCriterionType::setAddress()
     * @uses ItemSearchCriterionType::setTelephone()
     * @uses ItemSearchCriterionType::setRefPoint()
     * @uses ItemSearchCriterionType::setCodeRef()
     * @uses ItemSearchCriterionType::setHotelRef()
     * @uses ItemSearchCriterionType::setRadius()
     * @uses ItemSearchCriterionType::setMapArea()
     * @uses ItemSearchCriterionType::setExactMatch()
     * @uses ItemSearchCriterionType::setImportanceType()
     * @uses ItemSearchCriterionType::setRanking()
     * @param \Sabre\OTAPing\Structs\Position $position
     * @param \Sabre\OTAPing\Structs\Address $address
     * @param \Sabre\OTAPing\Structs\Telephone $telephone
     * @param \Sabre\OTAPing\Structs\RefPoint[] $refPoint
     * @param \Sabre\OTAPing\Structs\CodeRef $codeRef
     * @param \Sabre\OTAPing\Structs\HotelRef[] $hotelRef
     * @param \Sabre\OTAPing\Structs\Radius $radius
     * @param \Sabre\OTAPing\Structs\MapArea $mapArea
     * @param bool $exactMatch
     * @param string $importanceType
     * @param int $ranking
     */
    public function __construct(\Sabre\OTAPing\Structs\Position $position = null, \Sabre\OTAPing\Structs\Address $address = null, \Sabre\OTAPing\Structs\Telephone $telephone = null, array $refPoint = array(), \Sabre\OTAPing\Structs\CodeRef $codeRef = null, array $hotelRef = array(), \Sabre\OTAPing\Structs\Radius $radius = null, \Sabre\OTAPing\Structs\MapArea $mapArea = null, $exactMatch = null, $importanceType = null, $ranking = null)
    {
        $this
            ->setPosition($position)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setRefPoint($refPoint)
            ->setCodeRef($codeRef)
            ->setHotelRef($hotelRef)
            ->setRadius($radius)
            ->setMapArea($mapArea)
            ->setExactMatch($exactMatch)
            ->setImportanceType($importanceType)
            ->setRanking($ranking);
    }
    /**
     * Get Position value
     * @return \Sabre\OTAPing\Structs\Position|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param \Sabre\OTAPing\Structs\Position $position
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setPosition(\Sabre\OTAPing\Structs\Position $position = null)
    {
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Address value
     * @return \Sabre\OTAPing\Structs\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\OTAPing\Structs\Address $address
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setAddress(\Sabre\OTAPing\Structs\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\OTAPing\Structs\Telephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \Sabre\OTAPing\Structs\Telephone $telephone
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setTelephone(\Sabre\OTAPing\Structs\Telephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get RefPoint value
     * @return \Sabre\OTAPing\Structs\RefPoint[]|null
     */
    public function getRefPoint()
    {
        return $this->RefPoint;
    }
    /**
     * Set RefPoint value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\RefPoint[] $refPoint
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setRefPoint(array $refPoint = array())
    {
        $this->RefPoint = $refPoint;
        return $this;
    }
    /**
     * Add item to RefPoint value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\RefPoint $item
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function addToRefPoint(\Sabre\OTAPing\Structs\RefPoint $item)
    {
        $this->RefPoint[] = $item;
        return $this;
    }
    /**
     * Get CodeRef value
     * @return \Sabre\OTAPing\Structs\CodeRef|null
     */
    public function getCodeRef()
    {
        return $this->CodeRef;
    }
    /**
     * Set CodeRef value
     * @param \Sabre\OTAPing\Structs\CodeRef $codeRef
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setCodeRef(\Sabre\OTAPing\Structs\CodeRef $codeRef = null)
    {
        $this->CodeRef = $codeRef;
        return $this;
    }
    /**
     * Get HotelRef value
     * @return \Sabre\OTAPing\Structs\HotelRef[]|null
     */
    public function getHotelRef()
    {
        return $this->HotelRef;
    }
    /**
     * Set HotelRef value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\HotelRef[] $hotelRef
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setHotelRef(array $hotelRef = array())
    {
        $this->HotelRef = $hotelRef;
        return $this;
    }
    /**
     * Add item to HotelRef value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\HotelRef $item
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function addToHotelRef(\Sabre\OTAPing\Structs\HotelRef $item)
    {
        $this->HotelRef[] = $item;
        return $this;
    }
    /**
     * Get Radius value
     * @return \Sabre\OTAPing\Structs\Radius|null
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param \Sabre\OTAPing\Structs\Radius $radius
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setRadius(\Sabre\OTAPing\Structs\Radius $radius = null)
    {
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get MapArea value
     * @return \Sabre\OTAPing\Structs\MapArea|null
     */
    public function getMapArea()
    {
        return $this->MapArea;
    }
    /**
     * Set MapArea value
     * @param \Sabre\OTAPing\Structs\MapArea $mapArea
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setMapArea(\Sabre\OTAPing\Structs\MapArea $mapArea = null)
    {
        $this->MapArea = $mapArea;
        return $this;
    }
    /**
     * Get ExactMatch value
     * @return bool|null
     */
    public function getExactMatch()
    {
        return $this->ExactMatch;
    }
    /**
     * Set ExactMatch value
     * @param bool $exactMatch
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setExactMatch($exactMatch = null)
    {
        $this->ExactMatch = $exactMatch;
        return $this;
    }
    /**
     * Get ImportanceType value
     * @return string|null
     */
    public function getImportanceType()
    {
        return $this->ImportanceType;
    }
    /**
     * Set ImportanceType value
     * @param string $importanceType
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setImportanceType($importanceType = null)
    {
        $this->ImportanceType = $importanceType;
        return $this;
    }
    /**
     * Get Ranking value
     * @return int|null
     */
    public function getRanking()
    {
        return $this->Ranking;
    }
    /**
     * Set Ranking value
     * @param int $ranking
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public function setRanking($ranking = null)
    {
        $this->Ranking = $ranking;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\ItemSearchCriterionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
