<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageItemType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Details for an image of a given category.
 * @subpackage Structs
 */
class ImageItemType extends AbstractStructBase
{
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - documentation: URL of the multimedia item for a specific format.
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * The UnitOfMeasureCode
     * Meta informations extracted from the WSDL
     * - documentation: The unit of measure for the image item. Refer to OpenTravel Code list Unit of Measure (UOM).
     * - use: optional
     * @var string
     */
    public $UnitOfMeasureCode;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - documentation: The width of the image item (unit specified by unit of measure).
     * - use: optional
     * @var int
     */
    public $Width;
    /**
     * The Height
     * Meta informations extracted from the WSDL
     * - documentation: The height of the image item (unit specified by unit of measure).
     * - use: optional
     * @var int
     */
    public $Height;
    /**
     * Constructor method for ImageItemType
     * @uses ImageItemType::setURL()
     * @uses ImageItemType::setUnitOfMeasureCode()
     * @uses ImageItemType::setWidth()
     * @uses ImageItemType::setHeight()
     * @param string $uRL
     * @param string $unitOfMeasureCode
     * @param int $width
     * @param int $height
     */
    public function __construct($uRL = null, $unitOfMeasureCode = null, $width = null, $height = null)
    {
        $this
            ->setURL($uRL)
            ->setUnitOfMeasureCode($unitOfMeasureCode)
            ->setWidth($width)
            ->setHeight($height);
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \Sabre\OTAPing\Structs\ImageItemType
     */
    public function setURL($uRL = null)
    {
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Get UnitOfMeasureCode value
     * @return string|null
     */
    public function getUnitOfMeasureCode()
    {
        return $this->UnitOfMeasureCode;
    }
    /**
     * Set UnitOfMeasureCode value
     * @param string $unitOfMeasureCode
     * @return \Sabre\OTAPing\Structs\ImageItemType
     */
    public function setUnitOfMeasureCode($unitOfMeasureCode = null)
    {
        $this->UnitOfMeasureCode = $unitOfMeasureCode;
        return $this;
    }
    /**
     * Get Width value
     * @return int|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param int $width
     * @return \Sabre\OTAPing\Structs\ImageItemType
     */
    public function setWidth($width = null)
    {
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Height value
     * @return int|null
     */
    public function getHeight()
    {
        return $this->Height;
    }
    /**
     * Set Height value
     * @param int $height
     * @return \Sabre\OTAPing\Structs\ImageItemType
     */
    public function setHeight($height = null)
    {
        $this->Height = $height;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\ImageItemType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
