<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormattedTextSubSectionType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Used to provide subsection formatted text information.
 * @subpackage Structs
 */
class FormattedTextSubSectionType extends AbstractStructBase
{
    /**
     * The Paragraph
     * Meta informations extracted from the WSDL
     * - documentation: Details and content of a paragraph for a formatted text message.
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $Paragraph;
    /**
     * The SubTitle
     * Meta informations extracted from the WSDL
     * - documentation: This attribute may be used to provide a title for a sub-section of the formatted free text. A sub-section may have multiple related paragraphs of information. For example, if used to provide driving directions there may be multiple
     * paragraphs, and these paragraphs may be grouped into a sub-section called "Driving from the North". A second subsection may be titled "Driving from the South", and may contain several paragraphs to describe the driving directions when driving from
     * the south.
     * - use: optional
     * @var string
     */
    public $SubTitle;
    /**
     * The SubCode
     * Meta informations extracted from the WSDL
     * - documentation: An optional code that may be assigned to this sub-section of formatted free text.
     * - use: optional
     * @var string
     */
    public $SubCode;
    /**
     * The SubSectionNumber
     * Meta informations extracted from the WSDL
     * - documentation: This attribute may be used when there is a need to number all of the sub-sections of information that is to be presented.
     * - use: optional
     * @var string
     */
    public $SubSectionNumber;
    /**
     * Constructor method for FormattedTextSubSectionType
     * @uses FormattedTextSubSectionType::setParagraph()
     * @uses FormattedTextSubSectionType::setSubTitle()
     * @uses FormattedTextSubSectionType::setSubCode()
     * @uses FormattedTextSubSectionType::setSubSectionNumber()
     * @param mixed[] $paragraph
     * @param string $subTitle
     * @param string $subCode
     * @param string $subSectionNumber
     */
    public function __construct(array $paragraph = array(), $subTitle = null, $subCode = null, $subSectionNumber = null)
    {
        $this
            ->setParagraph($paragraph)
            ->setSubTitle($subTitle)
            ->setSubCode($subCode)
            ->setSubSectionNumber($subSectionNumber);
    }
    /**
     * Get Paragraph value
     * @return mixed[]|null
     */
    public function getParagraph()
    {
        return $this->Paragraph;
    }
    /**
     * Set Paragraph value
     * @throws \InvalidArgumentException
     * @param mixed[] $paragraph
     * @return \Sabre\OTAPing\Structs\FormattedTextSubSectionType
     */
    public function setParagraph(array $paragraph = array())
    {
        $this->Paragraph = $paragraph;
        return $this;
    }
    /**
     * Add item to Paragraph value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\FormattedTextSubSectionType
     */
    public function addToParagraph($item)
    {
        $this->Paragraph[] = $item;
        return $this;
    }
    /**
     * Get SubTitle value
     * @return string|null
     */
    public function getSubTitle()
    {
        return $this->SubTitle;
    }
    /**
     * Set SubTitle value
     * @param string $subTitle
     * @return \Sabre\OTAPing\Structs\FormattedTextSubSectionType
     */
    public function setSubTitle($subTitle = null)
    {
        $this->SubTitle = $subTitle;
        return $this;
    }
    /**
     * Get SubCode value
     * @return string|null
     */
    public function getSubCode()
    {
        return $this->SubCode;
    }
    /**
     * Set SubCode value
     * @param string $subCode
     * @return \Sabre\OTAPing\Structs\FormattedTextSubSectionType
     */
    public function setSubCode($subCode = null)
    {
        $this->SubCode = $subCode;
        return $this;
    }
    /**
     * Get SubSectionNumber value
     * @return string|null
     */
    public function getSubSectionNumber()
    {
        return $this->SubSectionNumber;
    }
    /**
     * Set SubSectionNumber value
     * @param string $subSectionNumber
     * @return \Sabre\OTAPing\Structs\FormattedTextSubSectionType
     */
    public function setSubSectionNumber($subSectionNumber = null)
    {
        $this->SubSectionNumber = $subSectionNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\FormattedTextSubSectionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
