<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Contains basic data on the customer's identity, location, relationships, finances, memberships, etc. | Identifies the gender of the customer. | Identifies the birth date of the customer. | Type of funds preferred for reviewing
 * monetary values, in ISO 4217 codes. | The primary language of the customer.
 * - type: StringLength1to8
 * - use: optional
 * @subpackage Structs
 */
class CustomerType extends AbstractStructBase
{
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - documentation: Detailed name information for the customer.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Telephone[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Email[]
     */
    public $Email;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Address[]
     */
    public $Address;
    /**
     * The URL
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\URL[]
     */
    public $URL;
    /**
     * The CitizenCountryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\CitizenCountryName[]
     */
    public $CitizenCountryName;
    /**
     * The PhysChallName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\PhysChallName[]
     */
    public $PhysChallName;
    /**
     * The PetInfo
     * Meta informations extracted from the WSDL
     * - documentation: Describes the customer's pet.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PetInfo;
    /**
     * The PaymentForm
     * Meta informations extracted from the WSDL
     * - maxOccurs: 100
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\PaymentForm[]
     */
    public $PaymentForm;
    /**
     * The RelatedTraveler
     * Meta informations extracted from the WSDL
     * - documentation: Identifies a traveler associated with the customer.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RelatedTraveler;
    /**
     * The ContactPerson
     * Meta informations extracted from the WSDL
     * - documentation: Information on a contact person for the customer.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ContactPerson;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - documentation: Detailed document information for the customer (e.g., driver license, passport, visa).
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Document;
    /**
     * The CustLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 25
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\CustLoyalty[]
     */
    public $CustLoyalty;
    /**
     * The EmployeeInfo
     * Meta informations extracted from the WSDL
     * - documentation: Employment information for the customer.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var mixed[]
     */
    public $EmployeeInfo;
    /**
     * The EmployerInfo
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the customer's employer.
     * - minOccurs: 0
     * @var mixed
     */
    public $EmployerInfo;
    /**
     * The AdditionalLanguage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\AdditionalLanguage[]
     */
    public $AdditionalLanguage;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The Deceased
     * Meta informations extracted from the WSDL
     * - documentation: When true the customer is deceased.
     * - use: optional
     * @var bool
     */
    public $Deceased;
    /**
     * The LockoutType
     * Meta informations extracted from the WSDL
     * - documentation: Indicates reason for locking out record, such as Emergency, Incident, etc.
     * - use: optional
     * @var string
     */
    public $LockoutType;
    /**
     * The VIP_Indicator
     * Meta informations extracted from the WSDL
     * - documentation: If true, indicates a very important person.
     * - use: optional
     * @var bool
     */
    public $VIP_Indicator;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: Used to specify textual information about the customer.
     * - use: optional
     * @var string
     */
    public $Text;
    /**
     * The CustomerValue
     * Meta informations extracted from the WSDL
     * - documentation: The supplier's ranking of the customer (e.g., VIP, numerical ranking).
     * - use: optional
     * @var string
     */
    public $CustomerValue;
    /**
     * The MaritalStatus
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MaritalStatus;
    /**
     * The PreviouslyMarriedIndicator
     * Meta informations extracted from the WSDL
     * - documentation: When true, indicates the customer was previously married. When false, indicates the customer was not previously married.
     * - use: optional
     * @var bool
     */
    public $PreviouslyMarriedIndicator;
    /**
     * The ChildQuantity
     * Meta informations extracted from the WSDL
     * - documentation: The number of children of the customer.
     * - use: optional
     * @var string
     */
    public $ChildQuantity;
    /**
     * Constructor method for CustomerType
     * @uses CustomerType::setPersonName()
     * @uses CustomerType::setTelephone()
     * @uses CustomerType::setEmail()
     * @uses CustomerType::setAddress()
     * @uses CustomerType::setURL()
     * @uses CustomerType::setCitizenCountryName()
     * @uses CustomerType::setPhysChallName()
     * @uses CustomerType::setPetInfo()
     * @uses CustomerType::setPaymentForm()
     * @uses CustomerType::setRelatedTraveler()
     * @uses CustomerType::setContactPerson()
     * @uses CustomerType::setDocument()
     * @uses CustomerType::setCustLoyalty()
     * @uses CustomerType::setEmployeeInfo()
     * @uses CustomerType::setEmployerInfo()
     * @uses CustomerType::setAdditionalLanguage()
     * @uses CustomerType::setTPA_Extensions()
     * @uses CustomerType::setDeceased()
     * @uses CustomerType::setLockoutType()
     * @uses CustomerType::setVIP_Indicator()
     * @uses CustomerType::setText()
     * @uses CustomerType::setCustomerValue()
     * @uses CustomerType::setMaritalStatus()
     * @uses CustomerType::setPreviouslyMarriedIndicator()
     * @uses CustomerType::setChildQuantity()
     * @param mixed[] $personName
     * @param \Sabre\OTAPing\Structs\Telephone[] $telephone
     * @param \Sabre\OTAPing\Structs\Email[] $email
     * @param \Sabre\OTAPing\Structs\Address[] $address
     * @param \Sabre\OTAPing\Structs\URL[] $uRL
     * @param \Sabre\OTAPing\Structs\CitizenCountryName[] $citizenCountryName
     * @param \Sabre\OTAPing\Structs\PhysChallName[] $physChallName
     * @param mixed[] $petInfo
     * @param \Sabre\OTAPing\Structs\PaymentForm[] $paymentForm
     * @param mixed[] $relatedTraveler
     * @param mixed[] $contactPerson
     * @param mixed[] $document
     * @param \Sabre\OTAPing\Structs\CustLoyalty[] $custLoyalty
     * @param mixed[] $employeeInfo
     * @param mixed $employerInfo
     * @param \Sabre\OTAPing\Structs\AdditionalLanguage[] $additionalLanguage
     * @param mixed $tPA_Extensions
     * @param bool $deceased
     * @param string $lockoutType
     * @param bool $vIP_Indicator
     * @param string $text
     * @param string $customerValue
     * @param string $maritalStatus
     * @param bool $previouslyMarriedIndicator
     * @param string $childQuantity
     */
    public function __construct(array $personName = array(), array $telephone = array(), array $email = array(), array $address = array(), array $uRL = array(), array $citizenCountryName = array(), array $physChallName = array(), array $petInfo = array(), array $paymentForm = array(), array $relatedTraveler = array(), array $contactPerson = array(), array $document = array(), array $custLoyalty = array(), array $employeeInfo = array(), $employerInfo = null, array $additionalLanguage = array(), $tPA_Extensions = null, $deceased = null, $lockoutType = null, $vIP_Indicator = null, $text = null, $customerValue = null, $maritalStatus = null, $previouslyMarriedIndicator = null, $childQuantity = null)
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setAddress($address)
            ->setURL($uRL)
            ->setCitizenCountryName($citizenCountryName)
            ->setPhysChallName($physChallName)
            ->setPetInfo($petInfo)
            ->setPaymentForm($paymentForm)
            ->setRelatedTraveler($relatedTraveler)
            ->setContactPerson($contactPerson)
            ->setDocument($document)
            ->setCustLoyalty($custLoyalty)
            ->setEmployeeInfo($employeeInfo)
            ->setEmployerInfo($employerInfo)
            ->setAdditionalLanguage($additionalLanguage)
            ->setTPA_Extensions($tPA_Extensions)
            ->setDeceased($deceased)
            ->setLockoutType($lockoutType)
            ->setVIP_Indicator($vIP_Indicator)
            ->setText($text)
            ->setCustomerValue($customerValue)
            ->setMaritalStatus($maritalStatus)
            ->setPreviouslyMarriedIndicator($previouslyMarriedIndicator)
            ->setChildQuantity($childQuantity);
    }
    /**
     * Get PersonName value
     * @return mixed[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param mixed[] $personName
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToPersonName($item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\OTAPing\Structs\Telephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Telephone[] $telephone
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Telephone $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToTelephone(\Sabre\OTAPing\Structs\Telephone $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \Sabre\OTAPing\Structs\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Email[] $email
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Email $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToEmail(\Sabre\OTAPing\Structs\Email $item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \Sabre\OTAPing\Structs\Address[]|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Address[] $address
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setAddress(array $address = array())
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Add item to Address value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Address $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToAddress(\Sabre\OTAPing\Structs\Address $item)
    {
        $this->Address[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return \Sabre\OTAPing\Structs\URL[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\URL[] $uRL
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setURL(array $uRL = array())
    {
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\URL $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToURL(\Sabre\OTAPing\Structs\URL $item)
    {
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get CitizenCountryName value
     * @return \Sabre\OTAPing\Structs\CitizenCountryName[]|null
     */
    public function getCitizenCountryName()
    {
        return $this->CitizenCountryName;
    }
    /**
     * Set CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\CitizenCountryName[] $citizenCountryName
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setCitizenCountryName(array $citizenCountryName = array())
    {
        $this->CitizenCountryName = $citizenCountryName;
        return $this;
    }
    /**
     * Add item to CitizenCountryName value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\CitizenCountryName $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToCitizenCountryName(\Sabre\OTAPing\Structs\CitizenCountryName $item)
    {
        $this->CitizenCountryName[] = $item;
        return $this;
    }
    /**
     * Get PhysChallName value
     * @return \Sabre\OTAPing\Structs\PhysChallName[]|null
     */
    public function getPhysChallName()
    {
        return $this->PhysChallName;
    }
    /**
     * Set PhysChallName value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\PhysChallName[] $physChallName
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setPhysChallName(array $physChallName = array())
    {
        $this->PhysChallName = $physChallName;
        return $this;
    }
    /**
     * Add item to PhysChallName value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\PhysChallName $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToPhysChallName(\Sabre\OTAPing\Structs\PhysChallName $item)
    {
        $this->PhysChallName[] = $item;
        return $this;
    }
    /**
     * Get PetInfo value
     * @return mixed[]|null
     */
    public function getPetInfo()
    {
        return $this->PetInfo;
    }
    /**
     * Set PetInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $petInfo
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setPetInfo(array $petInfo = array())
    {
        $this->PetInfo = $petInfo;
        return $this;
    }
    /**
     * Add item to PetInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToPetInfo($item)
    {
        $this->PetInfo[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \Sabre\OTAPing\Structs\PaymentForm[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\PaymentForm[] $paymentForm
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\PaymentForm $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToPaymentForm(\Sabre\OTAPing\Structs\PaymentForm $item)
    {
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get RelatedTraveler value
     * @return mixed[]|null
     */
    public function getRelatedTraveler()
    {
        return $this->RelatedTraveler;
    }
    /**
     * Set RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param mixed[] $relatedTraveler
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setRelatedTraveler(array $relatedTraveler = array())
    {
        $this->RelatedTraveler = $relatedTraveler;
        return $this;
    }
    /**
     * Add item to RelatedTraveler value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToRelatedTraveler($item)
    {
        $this->RelatedTraveler[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return mixed[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param mixed[] $contactPerson
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToContactPerson($item)
    {
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get Document value
     * @return mixed[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param mixed[] $document
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setDocument(array $document = array())
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToDocument($item)
    {
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \Sabre\OTAPing\Structs\CustLoyalty[]|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\CustLoyalty[] $custLoyalty
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setCustLoyalty(array $custLoyalty = array())
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Add item to CustLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\CustLoyalty $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToCustLoyalty(\Sabre\OTAPing\Structs\CustLoyalty $item)
    {
        $this->CustLoyalty[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return mixed[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $employeeInfo
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToEmployeeInfo($item)
    {
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get EmployerInfo value
     * @return mixed|null
     */
    public function getEmployerInfo()
    {
        return $this->EmployerInfo;
    }
    /**
     * Set EmployerInfo value
     * @param mixed $employerInfo
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setEmployerInfo($employerInfo = null)
    {
        $this->EmployerInfo = $employerInfo;
        return $this;
    }
    /**
     * Get AdditionalLanguage value
     * @return \Sabre\OTAPing\Structs\AdditionalLanguage[]|null
     */
    public function getAdditionalLanguage()
    {
        return $this->AdditionalLanguage;
    }
    /**
     * Set AdditionalLanguage value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\AdditionalLanguage[] $additionalLanguage
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setAdditionalLanguage(array $additionalLanguage = array())
    {
        $this->AdditionalLanguage = $additionalLanguage;
        return $this;
    }
    /**
     * Add item to AdditionalLanguage value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\AdditionalLanguage $item
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function addToAdditionalLanguage(\Sabre\OTAPing\Structs\AdditionalLanguage $item)
    {
        $this->AdditionalLanguage[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get Deceased value
     * @return bool|null
     */
    public function getDeceased()
    {
        return $this->Deceased;
    }
    /**
     * Set Deceased value
     * @param bool $deceased
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setDeceased($deceased = null)
    {
        $this->Deceased = $deceased;
        return $this;
    }
    /**
     * Get LockoutType value
     * @return string|null
     */
    public function getLockoutType()
    {
        return $this->LockoutType;
    }
    /**
     * Set LockoutType value
     * @param string $lockoutType
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setLockoutType($lockoutType = null)
    {
        $this->LockoutType = $lockoutType;
        return $this;
    }
    /**
     * Get VIP_Indicator value
     * @return bool|null
     */
    public function getVIP_Indicator()
    {
        return $this->VIP_Indicator;
    }
    /**
     * Set VIP_Indicator value
     * @param bool $vIP_Indicator
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setVIP_Indicator($vIP_Indicator = null)
    {
        $this->VIP_Indicator = $vIP_Indicator;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get CustomerValue value
     * @return string|null
     */
    public function getCustomerValue()
    {
        return $this->CustomerValue;
    }
    /**
     * Set CustomerValue value
     * @param string $customerValue
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setCustomerValue($customerValue = null)
    {
        $this->CustomerValue = $customerValue;
        return $this;
    }
    /**
     * Get MaritalStatus value
     * @return string|null
     */
    public function getMaritalStatus()
    {
        return $this->MaritalStatus;
    }
    /**
     * Set MaritalStatus value
     * @param string $maritalStatus
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setMaritalStatus($maritalStatus = null)
    {
        $this->MaritalStatus = $maritalStatus;
        return $this;
    }
    /**
     * Get PreviouslyMarriedIndicator value
     * @return bool|null
     */
    public function getPreviouslyMarriedIndicator()
    {
        return $this->PreviouslyMarriedIndicator;
    }
    /**
     * Set PreviouslyMarriedIndicator value
     * @param bool $previouslyMarriedIndicator
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setPreviouslyMarriedIndicator($previouslyMarriedIndicator = null)
    {
        $this->PreviouslyMarriedIndicator = $previouslyMarriedIndicator;
        return $this;
    }
    /**
     * Get ChildQuantity value
     * @return string|null
     */
    public function getChildQuantity()
    {
        return $this->ChildQuantity;
    }
    /**
     * Set ChildQuantity value
     * @param string $childQuantity
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public function setChildQuantity($childQuantity = null)
    {
        $this->ChildQuantity = $childQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\CustomerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
