<?php

namespace Sabre\OTAPing\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OTAP Services
 * @subpackage Services
 */
class OTAP extends AbstractSoapClientBase
{
    /**
     * Sets the MessageHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sabre\OTAPing\Structs\MessageHeader $messageHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMessageHeader(\Sabre\OTAPing\Structs\MessageHeader $messageHeader, $nameSpace = 'http://www.ebxml.org/namespaces/messageHeader', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MessageHeader', $messageHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the Security SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sabre\OTAPing\Structs\Security $security
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurity(\Sabre\OTAPing\Structs\Security $security, $nameSpace = 'http://schemas.xmlsoap.org/ws/2002/12/secext', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Security', $security, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named OTA_PingRQ
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: MessageHeader, Security
     * - SOAPHeaderNamespaces: http://www.ebxml.org/namespaces/messageHeader, http://schemas.xmlsoap.org/ws/2002/12/secext
     * - SOAPHeaderTypes: \Sabre\OTAPing\Structs\MessageHeader, \Sabre\OTAPing\Structs\Security
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sabre\OTAPing\Structs\OTA_PingRQ $body
     * @return \Sabre\OTAPing\Structs\OTA_PingRS|bool
     */
    public function OTA_PingRQ(\Sabre\OTAPing\Structs\OTA_PingRQ $body)
    {
        try {
            $this->setResult(self::getSoapClient()->OTA_PingRQ($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sabre\OTAPing\Structs\OTA_PingRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
