<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportationType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Defines the type of transportation offered.
 * @subpackage Structs
 */
class TransportationType extends AbstractStructBase
{
    /**
     * The Transportation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\OTAPing\Structs\Transportation[]
     */
    public $Transportation;
    /**
     * Constructor method for TransportationType
     * @uses TransportationType::setTransportation()
     * @param \Sabre\OTAPing\Structs\Transportation[] $transportation
     */
    public function __construct(array $transportation = array())
    {
        $this
            ->setTransportation($transportation);
    }
    /**
     * Get Transportation value
     * @return \Sabre\OTAPing\Structs\Transportation[]|null
     */
    public function getTransportation()
    {
        return $this->Transportation;
    }
    /**
     * Set Transportation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Transportation[] $transportation
     * @return \Sabre\OTAPing\Structs\TransportationType
     */
    public function setTransportation(array $transportation = array())
    {
        $this->Transportation = $transportation;
        return $this;
    }
    /**
     * Add item to Transportation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Transportation $item
     * @return \Sabre\OTAPing\Structs\TransportationType
     */
    public function addToTransportation(\Sabre\OTAPing\Structs\Transportation $item)
    {
        $this->Transportation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\TransportationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
