<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MonetaryRuleType Structs
 * Meta informations extracted from the WSDL
 * - documentation: This defines the information pertaining to rules and amounts associated with these rules. | Provides the currency amount pertaining to the rule. | Used for Character Strings, length 0 to 255.
 * - maxLength: 255
 * - minLength: 0
 * @subpackage Structs
 */
class MonetaryRuleType extends AbstractStructBase
{
    /**
     * The RuleType
     * Meta informations extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Rule Type (RUL).
     * - use: required
     * @var string
     */
    public $RuleType;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - documentation: The percent applicable to the monetary rule.
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * The DateTime
     * Meta informations extracted from the WSDL
     * - documentation: The date and time applicable to this monetary rule.
     * - use: optional
     * @var string
     */
    public $DateTime;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - documentation: Refer to OpenTravel Code List Payment Type (PMT).
     * - use: optional
     * @var string
     */
    public $PaymentType;
    /**
     * Constructor method for MonetaryRuleType
     * @uses MonetaryRuleType::setRuleType()
     * @uses MonetaryRuleType::setPercent()
     * @uses MonetaryRuleType::setDateTime()
     * @uses MonetaryRuleType::setPaymentType()
     * @param string $ruleType
     * @param string $percent
     * @param string $dateTime
     * @param string $paymentType
     */
    public function __construct($ruleType = null, $percent = null, $dateTime = null, $paymentType = null)
    {
        $this
            ->setRuleType($ruleType)
            ->setPercent($percent)
            ->setDateTime($dateTime)
            ->setPaymentType($paymentType);
    }
    /**
     * Get RuleType value
     * @return string
     */
    public function getRuleType()
    {
        return $this->RuleType;
    }
    /**
     * Set RuleType value
     * @param string $ruleType
     * @return \Sabre\OTAPing\Structs\MonetaryRuleType
     */
    public function setRuleType($ruleType = null)
    {
        $this->RuleType = $ruleType;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\OTAPing\Structs\MonetaryRuleType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \Sabre\OTAPing\Structs\MonetaryRuleType
     */
    public function setDateTime($dateTime = null)
    {
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \Sabre\OTAPing\Structs\MonetaryRuleType
     */
    public function setPaymentType($paymentType = null)
    {
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\MonetaryRuleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
