<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InfoCodes Structs
 * Meta informations extracted from the WSDL
 * - documentation: Collection of types of restaurant.
 * @subpackage Structs
 */
class InfoCodes extends AbstractStructBase
{
    /**
     * The InfoCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\OTAPing\Structs\InfoCode[]
     */
    public $InfoCode;
    /**
     * Constructor method for InfoCodes
     * @uses InfoCodes::setInfoCode()
     * @param \Sabre\OTAPing\Structs\InfoCode[] $infoCode
     */
    public function __construct(array $infoCode = array())
    {
        $this
            ->setInfoCode($infoCode);
    }
    /**
     * Get InfoCode value
     * @return \Sabre\OTAPing\Structs\InfoCode[]|null
     */
    public function getInfoCode()
    {
        return $this->InfoCode;
    }
    /**
     * Set InfoCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\InfoCode[] $infoCode
     * @return \Sabre\OTAPing\Structs\InfoCodes
     */
    public function setInfoCode(array $infoCode = array())
    {
        $this->InfoCode = $infoCode;
        return $this;
    }
    /**
     * Add item to InfoCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\InfoCode $item
     * @return \Sabre\OTAPing\Structs\InfoCodes
     */
    public function addToInfoCode(\Sabre\OTAPing\Structs\InfoCode $item)
    {
        $this->InfoCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\InfoCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
