<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageDescriptionType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Describes an image item.
 * @subpackage Structs
 */
class ImageDescriptionType extends AbstractStructBase
{
    /**
     * The ImageFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\ImageFormat[]
     */
    public $ImageFormat;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\Description[]
     */
    public $Description;
    /**
     * The Category
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the image category. Refer to OpenTravel Code list Picture Category Code (PIC).
     * - use: optional
     * @var string
     */
    public $Category;
    /**
     * Constructor method for ImageDescriptionType
     * @uses ImageDescriptionType::setImageFormat()
     * @uses ImageDescriptionType::setDescription()
     * @uses ImageDescriptionType::setCategory()
     * @param \Sabre\OTAPing\Structs\ImageFormat[] $imageFormat
     * @param \Sabre\OTAPing\Structs\Description[] $description
     * @param string $category
     */
    public function __construct(array $imageFormat = array(), array $description = array(), $category = null)
    {
        $this
            ->setImageFormat($imageFormat)
            ->setDescription($description)
            ->setCategory($category);
    }
    /**
     * Get ImageFormat value
     * @return \Sabre\OTAPing\Structs\ImageFormat[]|null
     */
    public function getImageFormat()
    {
        return $this->ImageFormat;
    }
    /**
     * Set ImageFormat value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\ImageFormat[] $imageFormat
     * @return \Sabre\OTAPing\Structs\ImageDescriptionType
     */
    public function setImageFormat(array $imageFormat = array())
    {
        $this->ImageFormat = $imageFormat;
        return $this;
    }
    /**
     * Add item to ImageFormat value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\ImageFormat $item
     * @return \Sabre\OTAPing\Structs\ImageDescriptionType
     */
    public function addToImageFormat(\Sabre\OTAPing\Structs\ImageFormat $item)
    {
        $this->ImageFormat[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \Sabre\OTAPing\Structs\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Description[] $description
     * @return \Sabre\OTAPing\Structs\ImageDescriptionType
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAPing\Structs\Description $item
     * @return \Sabre\OTAPing\Structs\ImageDescriptionType
     */
    public function addToDescription(\Sabre\OTAPing\Structs\Description $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \Sabre\OTAPing\Structs\ImageDescriptionType
     */
    public function setCategory($category = null)
    {
        $this->Category = $category;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\ImageDescriptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
