<?php

namespace Sabre\OTAPing\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Contains details pertaining to commissions. | Indicates the currency to be applied to the amounts located in the child elements.
 * @subpackage Structs
 */
class CommissionType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the recipient of the commission.
     * - minOccurs: 0
     * @var mixed
     */
    public $UniqueID;
    /**
     * The CommissionableAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\CommissionableAmount
     */
    public $CommissionableAmount;
    /**
     * The PrepaidAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\PrepaidAmount
     */
    public $PrepaidAmount;
    /**
     * The FlatCommission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\FlatCommission
     */
    public $FlatCommission;
    /**
     * The CommissionPayableAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAPing\Structs\CommissionPayableAmount
     */
    public $CommissionPayableAmount;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - documentation: Text related to the commission.
     * - minOccurs: 0
     * @var mixed
     */
    public $Comment;
    /**
     * The StatusType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $StatusType;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - documentation: The percent applied to the commissionable amount to determine the commission payable amount.
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * The ReasonCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifies the reason why a commission is not paid or not paid in full.
     * - use: optional
     * @var string
     */
    public $ReasonCode;
    /**
     * The BillToID
     * Meta informations extracted from the WSDL
     * - documentation: Identifies who should be billed for the commission amount.
     * - use: optional
     * @var string
     */
    public $BillToID;
    /**
     * The Frequency
     * Meta informations extracted from the WSDL
     * - documentation: This is the frequency at which the commission is applied (e.g. per stay, daily). Refer to OpenTravel Code List Charge Type (CHG).
     * - use: optional
     * @var string
     */
    public $Frequency;
    /**
     * The MaxCommissionUnitApplies
     * Meta informations extracted from the WSDL
     * - documentation: Maximum number of units for which the commission will be applied. This may be used in conjunction with the frequency attribute.
     * - use: optional
     * @var int
     */
    public $MaxCommissionUnitApplies;
    /**
     * The CapAmount
     * Meta informations extracted from the WSDL
     * - documentation: The highest monetary value that may be paid for the commission.
     * - use: optional
     * @var string
     */
    public $CapAmount;
    /**
     * Constructor method for CommissionType
     * @uses CommissionType::setUniqueID()
     * @uses CommissionType::setCommissionableAmount()
     * @uses CommissionType::setPrepaidAmount()
     * @uses CommissionType::setFlatCommission()
     * @uses CommissionType::setCommissionPayableAmount()
     * @uses CommissionType::setComment()
     * @uses CommissionType::setStatusType()
     * @uses CommissionType::setPercent()
     * @uses CommissionType::setReasonCode()
     * @uses CommissionType::setBillToID()
     * @uses CommissionType::setFrequency()
     * @uses CommissionType::setMaxCommissionUnitApplies()
     * @uses CommissionType::setCapAmount()
     * @param mixed $uniqueID
     * @param \Sabre\OTAPing\Structs\CommissionableAmount $commissionableAmount
     * @param \Sabre\OTAPing\Structs\PrepaidAmount $prepaidAmount
     * @param \Sabre\OTAPing\Structs\FlatCommission $flatCommission
     * @param \Sabre\OTAPing\Structs\CommissionPayableAmount $commissionPayableAmount
     * @param mixed $comment
     * @param string $statusType
     * @param string $percent
     * @param string $reasonCode
     * @param string $billToID
     * @param string $frequency
     * @param int $maxCommissionUnitApplies
     * @param string $capAmount
     */
    public function __construct($uniqueID = null, \Sabre\OTAPing\Structs\CommissionableAmount $commissionableAmount = null, \Sabre\OTAPing\Structs\PrepaidAmount $prepaidAmount = null, \Sabre\OTAPing\Structs\FlatCommission $flatCommission = null, \Sabre\OTAPing\Structs\CommissionPayableAmount $commissionPayableAmount = null, $comment = null, $statusType = null, $percent = null, $reasonCode = null, $billToID = null, $frequency = null, $maxCommissionUnitApplies = null, $capAmount = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setCommissionableAmount($commissionableAmount)
            ->setPrepaidAmount($prepaidAmount)
            ->setFlatCommission($flatCommission)
            ->setCommissionPayableAmount($commissionPayableAmount)
            ->setComment($comment)
            ->setStatusType($statusType)
            ->setPercent($percent)
            ->setReasonCode($reasonCode)
            ->setBillToID($billToID)
            ->setFrequency($frequency)
            ->setMaxCommissionUnitApplies($maxCommissionUnitApplies)
            ->setCapAmount($capAmount);
    }
    /**
     * Get UniqueID value
     * @return mixed|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param mixed $uniqueID
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setUniqueID($uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get CommissionableAmount value
     * @return \Sabre\OTAPing\Structs\CommissionableAmount|null
     */
    public function getCommissionableAmount()
    {
        return $this->CommissionableAmount;
    }
    /**
     * Set CommissionableAmount value
     * @param \Sabre\OTAPing\Structs\CommissionableAmount $commissionableAmount
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setCommissionableAmount(\Sabre\OTAPing\Structs\CommissionableAmount $commissionableAmount = null)
    {
        $this->CommissionableAmount = $commissionableAmount;
        return $this;
    }
    /**
     * Get PrepaidAmount value
     * @return \Sabre\OTAPing\Structs\PrepaidAmount|null
     */
    public function getPrepaidAmount()
    {
        return $this->PrepaidAmount;
    }
    /**
     * Set PrepaidAmount value
     * @param \Sabre\OTAPing\Structs\PrepaidAmount $prepaidAmount
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setPrepaidAmount(\Sabre\OTAPing\Structs\PrepaidAmount $prepaidAmount = null)
    {
        $this->PrepaidAmount = $prepaidAmount;
        return $this;
    }
    /**
     * Get FlatCommission value
     * @return \Sabre\OTAPing\Structs\FlatCommission|null
     */
    public function getFlatCommission()
    {
        return $this->FlatCommission;
    }
    /**
     * Set FlatCommission value
     * @param \Sabre\OTAPing\Structs\FlatCommission $flatCommission
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setFlatCommission(\Sabre\OTAPing\Structs\FlatCommission $flatCommission = null)
    {
        $this->FlatCommission = $flatCommission;
        return $this;
    }
    /**
     * Get CommissionPayableAmount value
     * @return \Sabre\OTAPing\Structs\CommissionPayableAmount|null
     */
    public function getCommissionPayableAmount()
    {
        return $this->CommissionPayableAmount;
    }
    /**
     * Set CommissionPayableAmount value
     * @param \Sabre\OTAPing\Structs\CommissionPayableAmount $commissionPayableAmount
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setCommissionPayableAmount(\Sabre\OTAPing\Structs\CommissionPayableAmount $commissionPayableAmount = null)
    {
        $this->CommissionPayableAmount = $commissionPayableAmount;
        return $this;
    }
    /**
     * Get Comment value
     * @return mixed|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param mixed $comment
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setComment($comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get StatusType value
     * @return string|null
     */
    public function getStatusType()
    {
        return $this->StatusType;
    }
    /**
     * Set StatusType value
     * @param string $statusType
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setStatusType($statusType = null)
    {
        $this->StatusType = $statusType;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setReasonCode($reasonCode = null)
    {
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get BillToID value
     * @return string|null
     */
    public function getBillToID()
    {
        return $this->BillToID;
    }
    /**
     * Set BillToID value
     * @param string $billToID
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setBillToID($billToID = null)
    {
        $this->BillToID = $billToID;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setFrequency($frequency = null)
    {
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get MaxCommissionUnitApplies value
     * @return int|null
     */
    public function getMaxCommissionUnitApplies()
    {
        return $this->MaxCommissionUnitApplies;
    }
    /**
     * Set MaxCommissionUnitApplies value
     * @param int $maxCommissionUnitApplies
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setMaxCommissionUnitApplies($maxCommissionUnitApplies = null)
    {
        $this->MaxCommissionUnitApplies = $maxCommissionUnitApplies;
        return $this;
    }
    /**
     * Get CapAmount value
     * @return string|null
     */
    public function getCapAmount()
    {
        return $this->CapAmount;
    }
    /**
     * Set CapAmount value
     * @param string $capAmount
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public function setCapAmount($capAmount = null)
    {
        $this->CapAmount = $capAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAPing\Structs\CommissionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
