<?php

namespace Sabre\OTAAirSchedule\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPrefs Structs
 * @subpackage Structs
 */
class VendorPrefs extends AbstractStructBase
{
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\Airline[]
     */
    public $Airline;
    /**
     * The Exclude
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Exclude;
    /**
     * The ExcludeCodeshares
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ExcludeCodeshares;
    /**
     * The Any
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Any;
    /**
     * Constructor method for VendorPrefs
     * @uses VendorPrefs::setAirline()
     * @uses VendorPrefs::setExclude()
     * @uses VendorPrefs::setExcludeCodeshares()
     * @uses VendorPrefs::setAny()
     * @param \Sabre\OTAAirSchedule\Structs\Airline[] $airline
     * @param bool $exclude
     * @param bool $excludeCodeshares
     * @param bool $any
     */
    public function __construct(array $airline = array(), $exclude = null, $excludeCodeshares = null, $any = null)
    {
        $this
            ->setAirline($airline)
            ->setExclude($exclude)
            ->setExcludeCodeshares($excludeCodeshares)
            ->setAny($any);
    }
    /**
     * Get Airline value
     * @return \Sabre\OTAAirSchedule\Structs\Airline[]|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\Airline[] $airline
     * @return \Sabre\OTAAirSchedule\Structs\VendorPrefs
     */
    public function setAirline(array $airline = array())
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Add item to Airline value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\Airline $item
     * @return \Sabre\OTAAirSchedule\Structs\VendorPrefs
     */
    public function addToAirline(\Sabre\OTAAirSchedule\Structs\Airline $item)
    {
        $this->Airline[] = $item;
        return $this;
    }
    /**
     * Get Exclude value
     * @return bool|null
     */
    public function getExclude()
    {
        return $this->Exclude;
    }
    /**
     * Set Exclude value
     * @param bool $exclude
     * @return \Sabre\OTAAirSchedule\Structs\VendorPrefs
     */
    public function setExclude($exclude = null)
    {
        $this->Exclude = $exclude;
        return $this;
    }
    /**
     * Get ExcludeCodeshares value
     * @return bool|null
     */
    public function getExcludeCodeshares()
    {
        return $this->ExcludeCodeshares;
    }
    /**
     * Set ExcludeCodeshares value
     * @param bool $excludeCodeshares
     * @return \Sabre\OTAAirSchedule\Structs\VendorPrefs
     */
    public function setExcludeCodeshares($excludeCodeshares = null)
    {
        $this->ExcludeCodeshares = $excludeCodeshares;
        return $this;
    }
    /**
     * Get Any value
     * @return bool|null
     */
    public function getAny()
    {
        return $this->Any;
    }
    /**
     * Set Any value
     * @param bool $any
     * @return \Sabre\OTAAirSchedule\Structs\VendorPrefs
     */
    public function setAny($any = null)
    {
        $this->Any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirSchedule\Structs\VendorPrefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
