<?php

namespace Sabre\OTAAirSchedule\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType Structs
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta informations extracted from the WSDL
     * - ref: ds:SignedInfo
     * @var \Sabre\OTAAirSchedule\Structs\SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta informations extracted from the WSDL
     * - ref: ds:SignatureValue
     * @var \Sabre\OTAAirSchedule\Structs\SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:KeyInfo
     * @var \Sabre\OTAAirSchedule\Structs\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Object
     * @var \Sabre\OTAAirSchedule\Structs\ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignatureType
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @param \Sabre\OTAAirSchedule\Structs\SignedInfoType $signedInfo
     * @param \Sabre\OTAAirSchedule\Structs\SignatureValueType $signatureValue
     * @param \Sabre\OTAAirSchedule\Structs\KeyInfoType $keyInfo
     * @param \Sabre\OTAAirSchedule\Structs\ObjectType[] $object
     * @param string $id
     */
    public function __construct(\Sabre\OTAAirSchedule\Structs\SignedInfoType $signedInfo = null, \Sabre\OTAAirSchedule\Structs\SignatureValueType $signatureValue = null, \Sabre\OTAAirSchedule\Structs\KeyInfoType $keyInfo = null, array $object = array(), $id = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id);
    }
    /**
     * Get SignedInfo value
     * @return \Sabre\OTAAirSchedule\Structs\SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }
    /**
     * Set SignedInfo value
     * @param \Sabre\OTAAirSchedule\Structs\SignedInfoType $signedInfo
     * @return \Sabre\OTAAirSchedule\Structs\SignatureType
     */
    public function setSignedInfo(\Sabre\OTAAirSchedule\Structs\SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }
    /**
     * Get SignatureValue value
     * @return \Sabre\OTAAirSchedule\Structs\SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }
    /**
     * Set SignatureValue value
     * @param \Sabre\OTAAirSchedule\Structs\SignatureValueType $signatureValue
     * @return \Sabre\OTAAirSchedule\Structs\SignatureType
     */
    public function setSignatureValue(\Sabre\OTAAirSchedule\Structs\SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \Sabre\OTAAirSchedule\Structs\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \Sabre\OTAAirSchedule\Structs\KeyInfoType $keyInfo
     * @return \Sabre\OTAAirSchedule\Structs\SignatureType
     */
    public function setKeyInfo(\Sabre\OTAAirSchedule\Structs\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get Object value
     * @return \Sabre\OTAAirSchedule\Structs\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\ObjectType[] $object
     * @return \Sabre\OTAAirSchedule\Structs\SignatureType
     */
    public function setObject(array $object = array())
    {
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\ObjectType $item
     * @return \Sabre\OTAAirSchedule\Structs\SignatureType
     */
    public function addToObject(\Sabre\OTAAirSchedule\Structs\ObjectType $item)
    {
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\OTAAirSchedule\Structs\SignatureType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirSchedule\Structs\SignatureType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
