<?php

namespace Sabre\OTAAirSchedule\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment Structs
 * @subpackage Structs
 */
class FlightSegment extends AbstractStructBase
{
    /**
     * The ConnectionLocations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\ConnectionLocations
     */
    public $ConnectionLocations;
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The ArrivalDateTime
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Allows all combinations of date and time
     * - pattern:
     * ((((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|
     * (1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T(([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}))|(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((2
     * 0[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))|(([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2})
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: Allows all combinations of date and time
     * - pattern:
     * ((((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|
     * (1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T(([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}))|(((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((2
     * 0[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))|(([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2})
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The BookingClassAvail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\BookingClassAvail[]
     */
    public $BookingClassAvail;
    /**
     * The DaysOfOperation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\DaysOfOperation
     */
    public $DaysOfOperation;
    /**
     * The DisclosureAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\DisclosureAirline
     */
    public $DisclosureAirline;
    /**
     * The Equipment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\Equipment
     */
    public $Equipment;
    /**
     * The FlightDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public $FlightDetails;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\MarketingAirline
     */
    public $MarketingAirline;
    /**
     * The Meal
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\Meal[]
     */
    public $Meal;
    /**
     * The OperatingAirline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\OperatingAirline
     */
    public $OperatingAirline;
    /**
     * The ConnectionInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ConnectionInd;
    /**
     * The DOT_Ind
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DOT_Ind;
    /**
     * The eTicket
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $eTicket;
    /**
     * The FlightNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FlightNumber;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The StopQuantity
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $StopQuantity;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setConnectionLocations()
     * @uses FlightSegment::setDestinationLocation()
     * @uses FlightSegment::setOriginLocation()
     * @uses FlightSegment::setArrivalDateTime()
     * @uses FlightSegment::setDepartureDateTime()
     * @uses FlightSegment::setBookingClassAvail()
     * @uses FlightSegment::setDaysOfOperation()
     * @uses FlightSegment::setDisclosureAirline()
     * @uses FlightSegment::setEquipment()
     * @uses FlightSegment::setFlightDetails()
     * @uses FlightSegment::setMarketingAirline()
     * @uses FlightSegment::setMeal()
     * @uses FlightSegment::setOperatingAirline()
     * @uses FlightSegment::setConnectionInd()
     * @uses FlightSegment::setDOT_Ind()
     * @uses FlightSegment::setETicket()
     * @uses FlightSegment::setFlightNumber()
     * @uses FlightSegment::setRPH()
     * @uses FlightSegment::setSmokingAllowed()
     * @uses FlightSegment::setStopQuantity()
     * @param \Sabre\OTAAirSchedule\Structs\ConnectionLocations $connectionLocations
     * @param \Sabre\OTAAirSchedule\Structs\DestinationLocation $destinationLocation
     * @param \Sabre\OTAAirSchedule\Structs\OriginLocation $originLocation
     * @param string $arrivalDateTime
     * @param string $departureDateTime
     * @param \Sabre\OTAAirSchedule\Structs\BookingClassAvail[] $bookingClassAvail
     * @param \Sabre\OTAAirSchedule\Structs\DaysOfOperation $daysOfOperation
     * @param \Sabre\OTAAirSchedule\Structs\DisclosureAirline $disclosureAirline
     * @param \Sabre\OTAAirSchedule\Structs\Equipment $equipment
     * @param \Sabre\OTAAirSchedule\Structs\FlightDetails $flightDetails
     * @param \Sabre\OTAAirSchedule\Structs\MarketingAirline $marketingAirline
     * @param \Sabre\OTAAirSchedule\Structs\Meal[] $meal
     * @param \Sabre\OTAAirSchedule\Structs\OperatingAirline $operatingAirline
     * @param string $connectionInd
     * @param string $dOT_Ind
     * @param bool $eTicket
     * @param string $flightNumber
     * @param string $rPH
     * @param bool $smokingAllowed
     * @param string $stopQuantity
     */
    public function __construct(\Sabre\OTAAirSchedule\Structs\ConnectionLocations $connectionLocations = null, \Sabre\OTAAirSchedule\Structs\DestinationLocation $destinationLocation = null, \Sabre\OTAAirSchedule\Structs\OriginLocation $originLocation = null, $arrivalDateTime = null, $departureDateTime = null, array $bookingClassAvail = array(), \Sabre\OTAAirSchedule\Structs\DaysOfOperation $daysOfOperation = null, \Sabre\OTAAirSchedule\Structs\DisclosureAirline $disclosureAirline = null, \Sabre\OTAAirSchedule\Structs\Equipment $equipment = null, \Sabre\OTAAirSchedule\Structs\FlightDetails $flightDetails = null, \Sabre\OTAAirSchedule\Structs\MarketingAirline $marketingAirline = null, array $meal = array(), \Sabre\OTAAirSchedule\Structs\OperatingAirline $operatingAirline = null, $connectionInd = null, $dOT_Ind = null, $eTicket = null, $flightNumber = null, $rPH = null, $smokingAllowed = null, $stopQuantity = null)
    {
        $this
            ->setConnectionLocations($connectionLocations)
            ->setDestinationLocation($destinationLocation)
            ->setOriginLocation($originLocation)
            ->setArrivalDateTime($arrivalDateTime)
            ->setDepartureDateTime($departureDateTime)
            ->setBookingClassAvail($bookingClassAvail)
            ->setDaysOfOperation($daysOfOperation)
            ->setDisclosureAirline($disclosureAirline)
            ->setEquipment($equipment)
            ->setFlightDetails($flightDetails)
            ->setMarketingAirline($marketingAirline)
            ->setMeal($meal)
            ->setOperatingAirline($operatingAirline)
            ->setConnectionInd($connectionInd)
            ->setDOT_Ind($dOT_Ind)
            ->setETicket($eTicket)
            ->setFlightNumber($flightNumber)
            ->setRPH($rPH)
            ->setSmokingAllowed($smokingAllowed)
            ->setStopQuantity($stopQuantity);
    }
    /**
     * Get ConnectionLocations value
     * @return \Sabre\OTAAirSchedule\Structs\ConnectionLocations|null
     */
    public function getConnectionLocations()
    {
        return $this->ConnectionLocations;
    }
    /**
     * Set ConnectionLocations value
     * @param \Sabre\OTAAirSchedule\Structs\ConnectionLocations $connectionLocations
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setConnectionLocations(\Sabre\OTAAirSchedule\Structs\ConnectionLocations $connectionLocations = null)
    {
        $this->ConnectionLocations = $connectionLocations;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\OTAAirSchedule\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\OTAAirSchedule\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setDestinationLocation(\Sabre\OTAAirSchedule\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\OTAAirSchedule\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\OTAAirSchedule\Structs\OriginLocation $originLocation
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setOriginLocation(\Sabre\OTAAirSchedule\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get BookingClassAvail value
     * @return \Sabre\OTAAirSchedule\Structs\BookingClassAvail[]|null
     */
    public function getBookingClassAvail()
    {
        return $this->BookingClassAvail;
    }
    /**
     * Set BookingClassAvail value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\BookingClassAvail[] $bookingClassAvail
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setBookingClassAvail(array $bookingClassAvail = array())
    {
        $this->BookingClassAvail = $bookingClassAvail;
        return $this;
    }
    /**
     * Add item to BookingClassAvail value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\BookingClassAvail $item
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function addToBookingClassAvail(\Sabre\OTAAirSchedule\Structs\BookingClassAvail $item)
    {
        $this->BookingClassAvail[] = $item;
        return $this;
    }
    /**
     * Get DaysOfOperation value
     * @return \Sabre\OTAAirSchedule\Structs\DaysOfOperation|null
     */
    public function getDaysOfOperation()
    {
        return $this->DaysOfOperation;
    }
    /**
     * Set DaysOfOperation value
     * @param \Sabre\OTAAirSchedule\Structs\DaysOfOperation $daysOfOperation
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setDaysOfOperation(\Sabre\OTAAirSchedule\Structs\DaysOfOperation $daysOfOperation = null)
    {
        $this->DaysOfOperation = $daysOfOperation;
        return $this;
    }
    /**
     * Get DisclosureAirline value
     * @return \Sabre\OTAAirSchedule\Structs\DisclosureAirline|null
     */
    public function getDisclosureAirline()
    {
        return $this->DisclosureAirline;
    }
    /**
     * Set DisclosureAirline value
     * @param \Sabre\OTAAirSchedule\Structs\DisclosureAirline $disclosureAirline
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setDisclosureAirline(\Sabre\OTAAirSchedule\Structs\DisclosureAirline $disclosureAirline = null)
    {
        $this->DisclosureAirline = $disclosureAirline;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \Sabre\OTAAirSchedule\Structs\Equipment|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \Sabre\OTAAirSchedule\Structs\Equipment $equipment
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setEquipment(\Sabre\OTAAirSchedule\Structs\Equipment $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get FlightDetails value
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails|null
     */
    public function getFlightDetails()
    {
        return $this->FlightDetails;
    }
    /**
     * Set FlightDetails value
     * @param \Sabre\OTAAirSchedule\Structs\FlightDetails $flightDetails
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setFlightDetails(\Sabre\OTAAirSchedule\Structs\FlightDetails $flightDetails = null)
    {
        $this->FlightDetails = $flightDetails;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \Sabre\OTAAirSchedule\Structs\MarketingAirline|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @param \Sabre\OTAAirSchedule\Structs\MarketingAirline $marketingAirline
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setMarketingAirline(\Sabre\OTAAirSchedule\Structs\MarketingAirline $marketingAirline = null)
    {
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Get Meal value
     * @return \Sabre\OTAAirSchedule\Structs\Meal[]|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * Set Meal value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\Meal[] $meal
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setMeal(array $meal = array())
    {
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Add item to Meal value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\Meal $item
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function addToMeal(\Sabre\OTAAirSchedule\Structs\Meal $item)
    {
        $this->Meal[] = $item;
        return $this;
    }
    /**
     * Get OperatingAirline value
     * @return \Sabre\OTAAirSchedule\Structs\OperatingAirline|null
     */
    public function getOperatingAirline()
    {
        return $this->OperatingAirline;
    }
    /**
     * Set OperatingAirline value
     * @param \Sabre\OTAAirSchedule\Structs\OperatingAirline $operatingAirline
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setOperatingAirline(\Sabre\OTAAirSchedule\Structs\OperatingAirline $operatingAirline = null)
    {
        $this->OperatingAirline = $operatingAirline;
        return $this;
    }
    /**
     * Get ConnectionInd value
     * @return string|null
     */
    public function getConnectionInd()
    {
        return $this->ConnectionInd;
    }
    /**
     * Set ConnectionInd value
     * @param string $connectionInd
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setConnectionInd($connectionInd = null)
    {
        $this->ConnectionInd = $connectionInd;
        return $this;
    }
    /**
     * Get DOT_Ind value
     * @return string|null
     */
    public function getDOT_Ind()
    {
        return $this->DOT_Ind;
    }
    /**
     * Set DOT_Ind value
     * @param string $dOT_Ind
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setDOT_Ind($dOT_Ind = null)
    {
        $this->DOT_Ind = $dOT_Ind;
        return $this;
    }
    /**
     * Get eTicket value
     * @return bool|null
     */
    public function getETicket()
    {
        return $this->eTicket;
    }
    /**
     * Set eTicket value
     * @param bool $eTicket
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setETicket($eTicket = null)
    {
        $this->eTicket = $eTicket;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setFlightNumber($flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setSmokingAllowed($smokingAllowed = null)
    {
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get StopQuantity value
     * @return string|null
     */
    public function getStopQuantity()
    {
        return $this->StopQuantity;
    }
    /**
     * Set StopQuantity value
     * @param string $stopQuantity
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public function setStopQuantity($stopQuantity = null)
    {
        $this->StopQuantity = $stopQuantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirSchedule\Structs\FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
