<?php

namespace Sabre\OTAAirSchedule\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightDetails Structs
 * @subpackage Structs
 */
class FlightDetails extends AbstractStructBase
{
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The Canceled
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Canceled;
    /**
     * The Charter
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Charter;
    /**
     * The CodeshareBlockDisplay
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CodeshareBlockDisplay;
    /**
     * The DiscontinueDate
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DiscontinueDate;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $EffectiveDate;
    /**
     * The TrafficRestrictionCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TrafficRestrictionCode;
    /**
     * Constructor method for FlightDetails
     * @uses FlightDetails::setText()
     * @uses FlightDetails::setCanceled()
     * @uses FlightDetails::setCharter()
     * @uses FlightDetails::setCodeshareBlockDisplay()
     * @uses FlightDetails::setDiscontinueDate()
     * @uses FlightDetails::setEffectiveDate()
     * @uses FlightDetails::setTrafficRestrictionCode()
     * @param string[] $text
     * @param bool $canceled
     * @param bool $charter
     * @param string $codeshareBlockDisplay
     * @param string $discontinueDate
     * @param string $effectiveDate
     * @param string $trafficRestrictionCode
     */
    public function __construct(array $text = array(), $canceled = null, $charter = null, $codeshareBlockDisplay = null, $discontinueDate = null, $effectiveDate = null, $trafficRestrictionCode = null)
    {
        $this
            ->setText($text)
            ->setCanceled($canceled)
            ->setCharter($charter)
            ->setCodeshareBlockDisplay($codeshareBlockDisplay)
            ->setDiscontinueDate($discontinueDate)
            ->setEffectiveDate($effectiveDate)
            ->setTrafficRestrictionCode($trafficRestrictionCode);
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get Canceled value
     * @return bool|null
     */
    public function getCanceled()
    {
        return $this->Canceled;
    }
    /**
     * Set Canceled value
     * @param bool $canceled
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public function setCanceled($canceled = null)
    {
        $this->Canceled = $canceled;
        return $this;
    }
    /**
     * Get Charter value
     * @return bool|null
     */
    public function getCharter()
    {
        return $this->Charter;
    }
    /**
     * Set Charter value
     * @param bool $charter
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public function setCharter($charter = null)
    {
        $this->Charter = $charter;
        return $this;
    }
    /**
     * Get CodeshareBlockDisplay value
     * @return string|null
     */
    public function getCodeshareBlockDisplay()
    {
        return $this->CodeshareBlockDisplay;
    }
    /**
     * Set CodeshareBlockDisplay value
     * @param string $codeshareBlockDisplay
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public function setCodeshareBlockDisplay($codeshareBlockDisplay = null)
    {
        $this->CodeshareBlockDisplay = $codeshareBlockDisplay;
        return $this;
    }
    /**
     * Get DiscontinueDate value
     * @return string|null
     */
    public function getDiscontinueDate()
    {
        return $this->DiscontinueDate;
    }
    /**
     * Set DiscontinueDate value
     * @param string $discontinueDate
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public function setDiscontinueDate($discontinueDate = null)
    {
        $this->DiscontinueDate = $discontinueDate;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get TrafficRestrictionCode value
     * @return string|null
     */
    public function getTrafficRestrictionCode()
    {
        return $this->TrafficRestrictionCode;
    }
    /**
     * Set TrafficRestrictionCode value
     * @param string $trafficRestrictionCode
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public function setTrafficRestrictionCode($trafficRestrictionCode = null)
    {
        $this->TrafficRestrictionCode = $trafficRestrictionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirSchedule\Structs\FlightDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
