<?php

namespace Sabre\OTAAirSchedule\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLocations Structs
 * @subpackage Structs
 */
class ConnectionLocations extends AbstractStructBase
{
    /**
     * The CarrierSpecificDisplay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\CarrierSpecificDisplay
     */
    public $CarrierSpecificDisplay;
    /**
     * The ConnectionLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * @var \Sabre\OTAAirSchedule\Structs\ConnectionLocation[]
     */
    public $ConnectionLocation;
    /**
     * The ConnectTimeOverrides
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirSchedule\Structs\ConnectTimeOverrides
     */
    public $ConnectTimeOverrides;
    /**
     * Constructor method for ConnectionLocations
     * @uses ConnectionLocations::setCarrierSpecificDisplay()
     * @uses ConnectionLocations::setConnectionLocation()
     * @uses ConnectionLocations::setConnectTimeOverrides()
     * @param \Sabre\OTAAirSchedule\Structs\CarrierSpecificDisplay $carrierSpecificDisplay
     * @param \Sabre\OTAAirSchedule\Structs\ConnectionLocation[] $connectionLocation
     * @param \Sabre\OTAAirSchedule\Structs\ConnectTimeOverrides $connectTimeOverrides
     */
    public function __construct(\Sabre\OTAAirSchedule\Structs\CarrierSpecificDisplay $carrierSpecificDisplay = null, array $connectionLocation = array(), \Sabre\OTAAirSchedule\Structs\ConnectTimeOverrides $connectTimeOverrides = null)
    {
        $this
            ->setCarrierSpecificDisplay($carrierSpecificDisplay)
            ->setConnectionLocation($connectionLocation)
            ->setConnectTimeOverrides($connectTimeOverrides);
    }
    /**
     * Get CarrierSpecificDisplay value
     * @return \Sabre\OTAAirSchedule\Structs\CarrierSpecificDisplay|null
     */
    public function getCarrierSpecificDisplay()
    {
        return $this->CarrierSpecificDisplay;
    }
    /**
     * Set CarrierSpecificDisplay value
     * @param \Sabre\OTAAirSchedule\Structs\CarrierSpecificDisplay $carrierSpecificDisplay
     * @return \Sabre\OTAAirSchedule\Structs\ConnectionLocations
     */
    public function setCarrierSpecificDisplay(\Sabre\OTAAirSchedule\Structs\CarrierSpecificDisplay $carrierSpecificDisplay = null)
    {
        $this->CarrierSpecificDisplay = $carrierSpecificDisplay;
        return $this;
    }
    /**
     * Get ConnectionLocation value
     * @return \Sabre\OTAAirSchedule\Structs\ConnectionLocation[]|null
     */
    public function getConnectionLocation()
    {
        return $this->ConnectionLocation;
    }
    /**
     * Set ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\ConnectionLocation[] $connectionLocation
     * @return \Sabre\OTAAirSchedule\Structs\ConnectionLocations
     */
    public function setConnectionLocation(array $connectionLocation = array())
    {
        $this->ConnectionLocation = $connectionLocation;
        return $this;
    }
    /**
     * Add item to ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirSchedule\Structs\ConnectionLocation $item
     * @return \Sabre\OTAAirSchedule\Structs\ConnectionLocations
     */
    public function addToConnectionLocation(\Sabre\OTAAirSchedule\Structs\ConnectionLocation $item)
    {
        $this->ConnectionLocation[] = $item;
        return $this;
    }
    /**
     * Get ConnectTimeOverrides value
     * @return \Sabre\OTAAirSchedule\Structs\ConnectTimeOverrides|null
     */
    public function getConnectTimeOverrides()
    {
        return $this->ConnectTimeOverrides;
    }
    /**
     * Set ConnectTimeOverrides value
     * @param \Sabre\OTAAirSchedule\Structs\ConnectTimeOverrides $connectTimeOverrides
     * @return \Sabre\OTAAirSchedule\Structs\ConnectionLocations
     */
    public function setConnectTimeOverrides(\Sabre\OTAAirSchedule\Structs\ConnectTimeOverrides $connectTimeOverrides = null)
    {
        $this->ConnectTimeOverrides = $connectTimeOverrides;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirSchedule\Structs\ConnectionLocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
