<?php

namespace Sabre\OTAAirSchedule\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OTAA Services
 * @subpackage Services
 */
class OTAA extends AbstractSoapClientBase
{
    /**
     * Sets the MessageHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sabre\OTAAirSchedule\Structs\MessageHeader $messageHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMessageHeader(\Sabre\OTAAirSchedule\Structs\MessageHeader $messageHeader, $nameSpace = 'http://www.ebxml.org/namespaces/messageHeader', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MessageHeader', $messageHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the Security SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sabre\OTAAirSchedule\Structs\Security $security
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurity(\Sabre\OTAAirSchedule\Structs\Security $security, $nameSpace = 'http://schemas.xmlsoap.org/ws/2002/12/secext', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Security', $security, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named OTA_AirScheduleRQ
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: MessageHeader, Security
     * - SOAPHeaderNamespaces: http://www.ebxml.org/namespaces/messageHeader, http://schemas.xmlsoap.org/ws/2002/12/secext
     * - SOAPHeaderTypes: \Sabre\OTAAirSchedule\Structs\MessageHeader, \Sabre\OTAAirSchedule\Structs\Security
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sabre\OTAAirSchedule\Structs\OTA_AirScheduleRQ $body
     * @return \Sabre\OTAAirSchedule\Structs\OTA_AirScheduleRS|bool
     */
    public function OTA_AirScheduleRQ(\Sabre\OTAAirSchedule\Structs\OTA_AirScheduleRQ $body)
    {
        try {
            $this->setResult(self::getSoapClient()->OTA_AirScheduleRQ($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sabre\OTAAirSchedule\Structs\OTA_AirScheduleRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
