<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/OTA_AirScheduleLLS2.1.0RQ.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://webservices.sabre.com/wsdl/tpfc/OTA_AirScheduleLLS2.1.0RQ.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Sabre\OTAAirSchedule\ClassMap::get(),
);
/**
 * Samples for OTAA ServiceType
 */
$oTAA = new \Sabre\OTAAirSchedule\Services\OTAA($options);
$oTAA->setSoapHeaderMessageHeader(new \Sabre\OTAAirSchedule\Structs\MessageHeader());
$oTAA->setSoapHeaderSecurity(new \Sabre\OTAAirSchedule\Structs\Security());
/**
 * Sample call for OTA_AirScheduleRQ operation/method
 */
if ($oTAA->OTA_AirScheduleRQ(new \Sabre\OTAAirSchedule\Structs\OTA_AirScheduleRQ()) !== false) {
    print_r($oTAA->getResult());
} else {
    print_r($oTAA->getLastError());
}
