<?php

namespace Sabre\OTAAirRules\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OriginDestinationLine Structs
 * @subpackage Structs
 */
class OriginDestinationLine extends AbstractStructBase
{
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirRules\Structs\Airline
     */
    public $Airline;
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirRules\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirRules\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The Rule
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Rule;
    /**
     * The TariffDescriptionNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TariffDescriptionNumber;
    /**
     * The TravelDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A full date type. Accepted format: "yyyy-mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern: \d{4}-\d{2}-\d{2} |
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $TravelDate;
    /**
     * Constructor method for OriginDestinationLine
     * @uses OriginDestinationLine::setAirline()
     * @uses OriginDestinationLine::setDestinationLocation()
     * @uses OriginDestinationLine::setOriginLocation()
     * @uses OriginDestinationLine::setRule()
     * @uses OriginDestinationLine::setTariffDescriptionNumber()
     * @uses OriginDestinationLine::setTravelDate()
     * @param \Sabre\OTAAirRules\Structs\Airline $airline
     * @param \Sabre\OTAAirRules\Structs\DestinationLocation $destinationLocation
     * @param \Sabre\OTAAirRules\Structs\OriginLocation $originLocation
     * @param string $rule
     * @param string $tariffDescriptionNumber
     * @param string $travelDate
     */
    public function __construct(\Sabre\OTAAirRules\Structs\Airline $airline = null, \Sabre\OTAAirRules\Structs\DestinationLocation $destinationLocation = null, \Sabre\OTAAirRules\Structs\OriginLocation $originLocation = null, $rule = null, $tariffDescriptionNumber = null, $travelDate = null)
    {
        $this
            ->setAirline($airline)
            ->setDestinationLocation($destinationLocation)
            ->setOriginLocation($originLocation)
            ->setRule($rule)
            ->setTariffDescriptionNumber($tariffDescriptionNumber)
            ->setTravelDate($travelDate);
    }
    /**
     * Get Airline value
     * @return \Sabre\OTAAirRules\Structs\Airline|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \Sabre\OTAAirRules\Structs\Airline $airline
     * @return \Sabre\OTAAirRules\Structs\OriginDestinationLine
     */
    public function setAirline(\Sabre\OTAAirRules\Structs\Airline $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\OTAAirRules\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\OTAAirRules\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\OTAAirRules\Structs\OriginDestinationLine
     */
    public function setDestinationLocation(\Sabre\OTAAirRules\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\OTAAirRules\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\OTAAirRules\Structs\OriginLocation $originLocation
     * @return \Sabre\OTAAirRules\Structs\OriginDestinationLine
     */
    public function setOriginLocation(\Sabre\OTAAirRules\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get Rule value
     * @return string|null
     */
    public function getRule()
    {
        return $this->Rule;
    }
    /**
     * Set Rule value
     * @param string $rule
     * @return \Sabre\OTAAirRules\Structs\OriginDestinationLine
     */
    public function setRule($rule = null)
    {
        $this->Rule = $rule;
        return $this;
    }
    /**
     * Get TariffDescriptionNumber value
     * @return string|null
     */
    public function getTariffDescriptionNumber()
    {
        return $this->TariffDescriptionNumber;
    }
    /**
     * Set TariffDescriptionNumber value
     * @param string $tariffDescriptionNumber
     * @return \Sabre\OTAAirRules\Structs\OriginDestinationLine
     */
    public function setTariffDescriptionNumber($tariffDescriptionNumber = null)
    {
        $this->TariffDescriptionNumber = $tariffDescriptionNumber;
        return $this;
    }
    /**
     * Get TravelDate value
     * @return string|null
     */
    public function getTravelDate()
    {
        return $this->TravelDate;
    }
    /**
     * Set TravelDate value
     * @param string $travelDate
     * @return \Sabre\OTAAirRules\Structs\OriginDestinationLine
     */
    public function setTravelDate($travelDate = null)
    {
        $this->TravelDate = $travelDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirRules\Structs\OriginDestinationLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
