<?php

namespace Sabre\OTAAirRules\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Historical Structs
 * @subpackage Structs
 */
class Historical extends AbstractStructBase
{
    /**
     * The TicketingDate
     * Meta informations extracted from the WSDL
     * - documentation: A full date type. Accepted format: "yyyy-mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern: \d{4}-\d{2}-\d{2} |
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $TicketingDate;
    /**
     * The TravelDate
     * Meta informations extracted from the WSDL
     * - documentation: A full date type. Accepted format: "yyyy-mm-dd" | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern: \d{4}-\d{2}-\d{2} |
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $TravelDate;
    /**
     * Constructor method for Historical
     * @uses Historical::setTicketingDate()
     * @uses Historical::setTravelDate()
     * @param string $ticketingDate
     * @param string $travelDate
     */
    public function __construct($ticketingDate = null, $travelDate = null)
    {
        $this
            ->setTicketingDate($ticketingDate)
            ->setTravelDate($travelDate);
    }
    /**
     * Get TicketingDate value
     * @return string|null
     */
    public function getTicketingDate()
    {
        return $this->TicketingDate;
    }
    /**
     * Set TicketingDate value
     * @param string $ticketingDate
     * @return \Sabre\OTAAirRules\Structs\Historical
     */
    public function setTicketingDate($ticketingDate = null)
    {
        $this->TicketingDate = $ticketingDate;
        return $this;
    }
    /**
     * Get TravelDate value
     * @return string|null
     */
    public function getTravelDate()
    {
        return $this->TravelDate;
    }
    /**
     * Set TravelDate value
     * @param string $travelDate
     * @return \Sabre\OTAAirRules\Structs\Historical
     */
    public function setTravelDate($travelDate = null)
    {
        $this->TravelDate = $travelDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirRules\Structs\Historical
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
