<?php

namespace Sabre\OTAAirRules\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightSegment Structs
 * @subpackage Structs
 */
class FlightSegment extends AbstractStructBase
{
    /**
     * The DestinationLocation
     * @var \Sabre\OTAAirRules\Structs\DestinationLocation
     */
    public $DestinationLocation;
    /**
     * The MarketingCarrier
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirRules\Structs\MarketingCarrier
     */
    public $MarketingCarrier;
    /**
     * The OriginLocation
     * @var \Sabre\OTAAirRules\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The DepartureDateTime
     * Meta informations extracted from the WSDL
     * - use: optional
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DepartureDateTime;
    /**
     * Constructor method for FlightSegment
     * @uses FlightSegment::setDestinationLocation()
     * @uses FlightSegment::setMarketingCarrier()
     * @uses FlightSegment::setOriginLocation()
     * @uses FlightSegment::setDepartureDateTime()
     * @param \Sabre\OTAAirRules\Structs\DestinationLocation $destinationLocation
     * @param \Sabre\OTAAirRules\Structs\MarketingCarrier $marketingCarrier
     * @param \Sabre\OTAAirRules\Structs\OriginLocation $originLocation
     * @param string $departureDateTime
     */
    public function __construct(\Sabre\OTAAirRules\Structs\DestinationLocation $destinationLocation = null, \Sabre\OTAAirRules\Structs\MarketingCarrier $marketingCarrier = null, \Sabre\OTAAirRules\Structs\OriginLocation $originLocation = null, $departureDateTime = null)
    {
        $this
            ->setDestinationLocation($destinationLocation)
            ->setMarketingCarrier($marketingCarrier)
            ->setOriginLocation($originLocation)
            ->setDepartureDateTime($departureDateTime);
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\OTAAirRules\Structs\DestinationLocation|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param \Sabre\OTAAirRules\Structs\DestinationLocation $destinationLocation
     * @return \Sabre\OTAAirRules\Structs\FlightSegment
     */
    public function setDestinationLocation(\Sabre\OTAAirRules\Structs\DestinationLocation $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Get MarketingCarrier value
     * @return \Sabre\OTAAirRules\Structs\MarketingCarrier|null
     */
    public function getMarketingCarrier()
    {
        return $this->MarketingCarrier;
    }
    /**
     * Set MarketingCarrier value
     * @param \Sabre\OTAAirRules\Structs\MarketingCarrier $marketingCarrier
     * @return \Sabre\OTAAirRules\Structs\FlightSegment
     */
    public function setMarketingCarrier(\Sabre\OTAAirRules\Structs\MarketingCarrier $marketingCarrier = null)
    {
        $this->MarketingCarrier = $marketingCarrier;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\OTAAirRules\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\OTAAirRules\Structs\OriginLocation $originLocation
     * @return \Sabre\OTAAirRules\Structs\FlightSegment
     */
    public function setOriginLocation(\Sabre\OTAAirRules\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \Sabre\OTAAirRules\Structs\FlightSegment
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirRules\Structs\FlightSegment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
