<?php

namespace Sabre\OTAAirRules\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerTypeLine Structs
 * @subpackage Structs
 */
class PassengerTypeLine extends AbstractStructBase
{
    /**
     * The AutoPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AutoPrice;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\OTAAirRules\Structs\PassengerType[]
     */
    public $PassengerType;
    /**
     * Constructor method for PassengerTypeLine
     * @uses PassengerTypeLine::setAutoPrice()
     * @uses PassengerTypeLine::setPassengerType()
     * @param string $autoPrice
     * @param \Sabre\OTAAirRules\Structs\PassengerType[] $passengerType
     */
    public function __construct($autoPrice = null, array $passengerType = array())
    {
        $this
            ->setAutoPrice($autoPrice)
            ->setPassengerType($passengerType);
    }
    /**
     * Get AutoPrice value
     * @return string|null
     */
    public function getAutoPrice()
    {
        return $this->AutoPrice;
    }
    /**
     * Set AutoPrice value
     * @param string $autoPrice
     * @return \Sabre\OTAAirRules\Structs\PassengerTypeLine
     */
    public function setAutoPrice($autoPrice = null)
    {
        $this->AutoPrice = $autoPrice;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return \Sabre\OTAAirRules\Structs\PassengerType[]|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirRules\Structs\PassengerType[] $passengerType
     * @return \Sabre\OTAAirRules\Structs\PassengerTypeLine
     */
    public function setPassengerType(array $passengerType = array())
    {
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Add item to PassengerType value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirRules\Structs\PassengerType $item
     * @return \Sabre\OTAAirRules\Structs\PassengerTypeLine
     */
    public function addToPassengerType(\Sabre\OTAAirRules\Structs\PassengerType $item)
    {
        $this->PassengerType[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirRules\Structs\PassengerTypeLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
