<?php

namespace Sabre\OTAAirAvail\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VendorPrefs Structs
 * @subpackage Structs
 */
class VendorPrefs extends AbstractStructBase
{
    /**
     * The Airline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \Sabre\OTAAirAvail\Structs\Airline[]
     */
    public $Airline;
    /**
     * The DirectAccess
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $DirectAccess;
    /**
     * The Exclude
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Exclude;
    /**
     * The ExcludeCodeshares
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ExcludeCodeshares;
    /**
     * The Any
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $Any;
    /**
     * Constructor method for VendorPrefs
     * @uses VendorPrefs::setAirline()
     * @uses VendorPrefs::setDirectAccess()
     * @uses VendorPrefs::setExclude()
     * @uses VendorPrefs::setExcludeCodeshares()
     * @uses VendorPrefs::setAny()
     * @param \Sabre\OTAAirAvail\Structs\Airline[] $airline
     * @param bool $directAccess
     * @param bool $exclude
     * @param bool $excludeCodeshares
     * @param bool $any
     */
    public function __construct(array $airline = array(), $directAccess = null, $exclude = null, $excludeCodeshares = null, $any = null)
    {
        $this
            ->setAirline($airline)
            ->setDirectAccess($directAccess)
            ->setExclude($exclude)
            ->setExcludeCodeshares($excludeCodeshares)
            ->setAny($any);
    }
    /**
     * Get Airline value
     * @return \Sabre\OTAAirAvail\Structs\Airline[]|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirAvail\Structs\Airline[] $airline
     * @return \Sabre\OTAAirAvail\Structs\VendorPrefs
     */
    public function setAirline(array $airline = array())
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Add item to Airline value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirAvail\Structs\Airline $item
     * @return \Sabre\OTAAirAvail\Structs\VendorPrefs
     */
    public function addToAirline(\Sabre\OTAAirAvail\Structs\Airline $item)
    {
        $this->Airline[] = $item;
        return $this;
    }
    /**
     * Get DirectAccess value
     * @return bool|null
     */
    public function getDirectAccess()
    {
        return $this->DirectAccess;
    }
    /**
     * Set DirectAccess value
     * @param bool $directAccess
     * @return \Sabre\OTAAirAvail\Structs\VendorPrefs
     */
    public function setDirectAccess($directAccess = null)
    {
        $this->DirectAccess = $directAccess;
        return $this;
    }
    /**
     * Get Exclude value
     * @return bool|null
     */
    public function getExclude()
    {
        return $this->Exclude;
    }
    /**
     * Set Exclude value
     * @param bool $exclude
     * @return \Sabre\OTAAirAvail\Structs\VendorPrefs
     */
    public function setExclude($exclude = null)
    {
        $this->Exclude = $exclude;
        return $this;
    }
    /**
     * Get ExcludeCodeshares value
     * @return bool|null
     */
    public function getExcludeCodeshares()
    {
        return $this->ExcludeCodeshares;
    }
    /**
     * Set ExcludeCodeshares value
     * @param bool $excludeCodeshares
     * @return \Sabre\OTAAirAvail\Structs\VendorPrefs
     */
    public function setExcludeCodeshares($excludeCodeshares = null)
    {
        $this->ExcludeCodeshares = $excludeCodeshares;
        return $this;
    }
    /**
     * Get Any value
     * @return bool|null
     */
    public function getAny()
    {
        return $this->Any;
    }
    /**
     * Set Any value
     * @param bool $any
     * @return \Sabre\OTAAirAvail\Structs\VendorPrefs
     */
    public function setAny($any = null)
    {
        $this->Any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirAvail\Structs\VendorPrefs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
