<?php

namespace Sabre\OTAAirAvail\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrivalTime Structs
 * @subpackage Structs
 */
class ArrivalTime extends AbstractStructBase
{
    /**
     * The WindowAfter
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: A simple time type. Seconds can be omitted, since those values are not propagated to the Sabre backend systems. Accepted formats: "hh:mm:ss" or "hh:mm"
     * - pattern: ([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $WindowAfter;
    /**
     * The WindowBefore
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: A simple time type. Seconds can be omitted, since those values are not propagated to the Sabre backend systems. Accepted formats: "hh:mm:ss" or "hh:mm"
     * - pattern: ([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $WindowBefore;
    /**
     * Constructor method for ArrivalTime
     * @uses ArrivalTime::setWindowAfter()
     * @uses ArrivalTime::setWindowBefore()
     * @param string $windowAfter
     * @param string $windowBefore
     */
    public function __construct($windowAfter = null, $windowBefore = null)
    {
        $this
            ->setWindowAfter($windowAfter)
            ->setWindowBefore($windowBefore);
    }
    /**
     * Get WindowAfter value
     * @return string
     */
    public function getWindowAfter()
    {
        return $this->WindowAfter;
    }
    /**
     * Set WindowAfter value
     * @param string $windowAfter
     * @return \Sabre\OTAAirAvail\Structs\ArrivalTime
     */
    public function setWindowAfter($windowAfter = null)
    {
        $this->WindowAfter = $windowAfter;
        return $this;
    }
    /**
     * Get WindowBefore value
     * @return string
     */
    public function getWindowBefore()
    {
        return $this->WindowBefore;
    }
    /**
     * Set WindowBefore value
     * @param string $windowBefore
     * @return \Sabre\OTAAirAvail\Structs\ArrivalTime
     */
    public function setWindowBefore($windowBefore = null)
    {
        $this->WindowBefore = $windowBefore;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirAvail\Structs\ArrivalTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
