<?php

namespace Sabre\OTAAirAvail\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType Structs
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta informations extracted from the WSDL
     * - ref: ds:SignedInfo
     * @var \Sabre\OTAAirAvail\Structs\SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta informations extracted from the WSDL
     * - ref: ds:SignatureValue
     * @var \Sabre\OTAAirAvail\Structs\SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:KeyInfo
     * @var \Sabre\OTAAirAvail\Structs\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Object
     * @var \Sabre\OTAAirAvail\Structs\ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignatureType
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @param \Sabre\OTAAirAvail\Structs\SignedInfoType $signedInfo
     * @param \Sabre\OTAAirAvail\Structs\SignatureValueType $signatureValue
     * @param \Sabre\OTAAirAvail\Structs\KeyInfoType $keyInfo
     * @param \Sabre\OTAAirAvail\Structs\ObjectType[] $object
     * @param string $id
     */
    public function __construct(\Sabre\OTAAirAvail\Structs\SignedInfoType $signedInfo = null, \Sabre\OTAAirAvail\Structs\SignatureValueType $signatureValue = null, \Sabre\OTAAirAvail\Structs\KeyInfoType $keyInfo = null, array $object = array(), $id = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id);
    }
    /**
     * Get SignedInfo value
     * @return \Sabre\OTAAirAvail\Structs\SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }
    /**
     * Set SignedInfo value
     * @param \Sabre\OTAAirAvail\Structs\SignedInfoType $signedInfo
     * @return \Sabre\OTAAirAvail\Structs\SignatureType
     */
    public function setSignedInfo(\Sabre\OTAAirAvail\Structs\SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }
    /**
     * Get SignatureValue value
     * @return \Sabre\OTAAirAvail\Structs\SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }
    /**
     * Set SignatureValue value
     * @param \Sabre\OTAAirAvail\Structs\SignatureValueType $signatureValue
     * @return \Sabre\OTAAirAvail\Structs\SignatureType
     */
    public function setSignatureValue(\Sabre\OTAAirAvail\Structs\SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \Sabre\OTAAirAvail\Structs\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \Sabre\OTAAirAvail\Structs\KeyInfoType $keyInfo
     * @return \Sabre\OTAAirAvail\Structs\SignatureType
     */
    public function setKeyInfo(\Sabre\OTAAirAvail\Structs\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get Object value
     * @return \Sabre\OTAAirAvail\Structs\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirAvail\Structs\ObjectType[] $object
     * @return \Sabre\OTAAirAvail\Structs\SignatureType
     */
    public function setObject(array $object = array())
    {
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirAvail\Structs\ObjectType $item
     * @return \Sabre\OTAAirAvail\Structs\SignatureType
     */
    public function addToObject(\Sabre\OTAAirAvail\Structs\ObjectType $item)
    {
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\OTAAirAvail\Structs\SignatureType
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirAvail\Structs\SignatureType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
