<?php

namespace Sabre\OTAAirAvail\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepartureTime Structs
 * @subpackage Structs
 */
class DepartureTime extends AbstractStructBase
{
    /**
     * The WindowBefore
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: A simple time type. Seconds can be omitted, since those values are not propagated to the Sabre backend systems. Accepted formats: "hh:mm:ss" or "hh:mm"
     * - pattern: ([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $WindowBefore;
    /**
     * The WindowAfter
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: A simple time type. Seconds can be omitted, since those values are not propagated to the Sabre backend systems. Accepted formats: "hh:mm:ss" or "hh:mm"
     * - pattern: ([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $WindowAfter;
    /**
     * Constructor method for DepartureTime
     * @uses DepartureTime::setWindowBefore()
     * @uses DepartureTime::setWindowAfter()
     * @param string $windowBefore
     * @param string $windowAfter
     */
    public function __construct($windowBefore = null, $windowAfter = null)
    {
        $this
            ->setWindowBefore($windowBefore)
            ->setWindowAfter($windowAfter);
    }
    /**
     * Get WindowBefore value
     * @return string
     */
    public function getWindowBefore()
    {
        return $this->WindowBefore;
    }
    /**
     * Set WindowBefore value
     * @param string $windowBefore
     * @return \Sabre\OTAAirAvail\Structs\DepartureTime
     */
    public function setWindowBefore($windowBefore = null)
    {
        $this->WindowBefore = $windowBefore;
        return $this;
    }
    /**
     * Get WindowAfter value
     * @return string
     */
    public function getWindowAfter()
    {
        return $this->WindowAfter;
    }
    /**
     * Set WindowAfter value
     * @param string $windowAfter
     * @return \Sabre\OTAAirAvail\Structs\DepartureTime
     */
    public function setWindowAfter($windowAfter = null)
    {
        $this->WindowAfter = $windowAfter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirAvail\Structs\DepartureTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
