<?php

namespace Sabre\OTAAirAvail\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLocations Structs
 * @subpackage Structs
 */
class ConnectionLocations extends AbstractStructBase
{
    /**
     * The CarrierSpecificDisplay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirAvail\Structs\CarrierSpecificDisplay
     */
    public $CarrierSpecificDisplay;
    /**
     * The ConnectionLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * @var \Sabre\OTAAirAvail\Structs\ConnectionLocation[]
     */
    public $ConnectionLocation;
    /**
     * Constructor method for ConnectionLocations
     * @uses ConnectionLocations::setCarrierSpecificDisplay()
     * @uses ConnectionLocations::setConnectionLocation()
     * @param \Sabre\OTAAirAvail\Structs\CarrierSpecificDisplay $carrierSpecificDisplay
     * @param \Sabre\OTAAirAvail\Structs\ConnectionLocation[] $connectionLocation
     */
    public function __construct(\Sabre\OTAAirAvail\Structs\CarrierSpecificDisplay $carrierSpecificDisplay = null, array $connectionLocation = array())
    {
        $this
            ->setCarrierSpecificDisplay($carrierSpecificDisplay)
            ->setConnectionLocation($connectionLocation);
    }
    /**
     * Get CarrierSpecificDisplay value
     * @return \Sabre\OTAAirAvail\Structs\CarrierSpecificDisplay|null
     */
    public function getCarrierSpecificDisplay()
    {
        return $this->CarrierSpecificDisplay;
    }
    /**
     * Set CarrierSpecificDisplay value
     * @param \Sabre\OTAAirAvail\Structs\CarrierSpecificDisplay $carrierSpecificDisplay
     * @return \Sabre\OTAAirAvail\Structs\ConnectionLocations
     */
    public function setCarrierSpecificDisplay(\Sabre\OTAAirAvail\Structs\CarrierSpecificDisplay $carrierSpecificDisplay = null)
    {
        $this->CarrierSpecificDisplay = $carrierSpecificDisplay;
        return $this;
    }
    /**
     * Get ConnectionLocation value
     * @return \Sabre\OTAAirAvail\Structs\ConnectionLocation[]|null
     */
    public function getConnectionLocation()
    {
        return $this->ConnectionLocation;
    }
    /**
     * Set ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirAvail\Structs\ConnectionLocation[] $connectionLocation
     * @return \Sabre\OTAAirAvail\Structs\ConnectionLocations
     */
    public function setConnectionLocation(array $connectionLocation = array())
    {
        $this->ConnectionLocation = $connectionLocation;
        return $this;
    }
    /**
     * Add item to ConnectionLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirAvail\Structs\ConnectionLocation $item
     * @return \Sabre\OTAAirAvail\Structs\ConnectionLocations
     */
    public function addToConnectionLocation(\Sabre\OTAAirAvail\Structs\ConnectionLocation $item)
    {
        $this->ConnectionLocation[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirAvail\Structs\ConnectionLocations
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
