<?php

namespace Sabre\OTAAirAvail\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLocation Structs
 * @subpackage Structs
 */
class ConnectionLocation extends AbstractStructBase
{
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $LocationCode;
    /**
     * The ConnectTimeOverrides
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirAvail\Structs\ConnectTimeOverrides
     */
    public $ConnectTimeOverrides;
    /**
     * Constructor method for ConnectionLocation
     * @uses ConnectionLocation::setLocationCode()
     * @uses ConnectionLocation::setConnectTimeOverrides()
     * @param string $locationCode
     * @param \Sabre\OTAAirAvail\Structs\ConnectTimeOverrides $connectTimeOverrides
     */
    public function __construct($locationCode = null, \Sabre\OTAAirAvail\Structs\ConnectTimeOverrides $connectTimeOverrides = null)
    {
        $this
            ->setLocationCode($locationCode)
            ->setConnectTimeOverrides($connectTimeOverrides);
    }
    /**
     * Get LocationCode value
     * @return string
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\OTAAirAvail\Structs\ConnectionLocation
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get ConnectTimeOverrides value
     * @return \Sabre\OTAAirAvail\Structs\ConnectTimeOverrides|null
     */
    public function getConnectTimeOverrides()
    {
        return $this->ConnectTimeOverrides;
    }
    /**
     * Set ConnectTimeOverrides value
     * @param \Sabre\OTAAirAvail\Structs\ConnectTimeOverrides $connectTimeOverrides
     * @return \Sabre\OTAAirAvail\Structs\ConnectionLocation
     */
    public function setConnectTimeOverrides(\Sabre\OTAAirAvail\Structs\ConnectTimeOverrides $connectTimeOverrides = null)
    {
        $this->ConnectTimeOverrides = $connectTimeOverrides;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirAvail\Structs\ConnectionLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
