<?php

namespace Sabre\OTAAirAvail\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingClassAvail Structs
 * @subpackage Structs
 */
class BookingClassAvail extends AbstractStructBase
{
    /**
     * The Availability
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Availability;
    /**
     * The BrandID
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $BrandID;
    /**
     * The ResBookDesigCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The AggregatedContent
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $AggregatedContent;
    /**
     * Constructor method for BookingClassAvail
     * @uses BookingClassAvail::setAvailability()
     * @uses BookingClassAvail::setBrandID()
     * @uses BookingClassAvail::setResBookDesigCode()
     * @uses BookingClassAvail::setRPH()
     * @uses BookingClassAvail::setAggregatedContent()
     * @param string $availability
     * @param string $brandID
     * @param string $resBookDesigCode
     * @param string $rPH
     * @param bool $aggregatedContent
     */
    public function __construct($availability = null, $brandID = null, $resBookDesigCode = null, $rPH = null, $aggregatedContent = null)
    {
        $this
            ->setAvailability($availability)
            ->setBrandID($brandID)
            ->setResBookDesigCode($resBookDesigCode)
            ->setRPH($rPH)
            ->setAggregatedContent($aggregatedContent);
    }
    /**
     * Get Availability value
     * @return string|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @param string $availability
     * @return \Sabre\OTAAirAvail\Structs\BookingClassAvail
     */
    public function setAvailability($availability = null)
    {
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get BrandID value
     * @return string|null
     */
    public function getBrandID()
    {
        return $this->BrandID;
    }
    /**
     * Set BrandID value
     * @param string $brandID
     * @return \Sabre\OTAAirAvail\Structs\BookingClassAvail
     */
    public function setBrandID($brandID = null)
    {
        $this->BrandID = $brandID;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \Sabre\OTAAirAvail\Structs\BookingClassAvail
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\OTAAirAvail\Structs\BookingClassAvail
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get AggregatedContent value
     * @return bool|null
     */
    public function getAggregatedContent()
    {
        return $this->AggregatedContent;
    }
    /**
     * Set AggregatedContent value
     * @param bool $aggregatedContent
     * @return \Sabre\OTAAirAvail\Structs\BookingClassAvail
     */
    public function setAggregatedContent($aggregatedContent = null)
    {
        $this->AggregatedContent = $aggregatedContent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirAvail\Structs\BookingClassAvail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
