<?php

namespace Sabre\OTAAirAvail\Services;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for OTAA Services
 * @subpackage Services
 */
class OTAA extends AbstractSoapClientBase
{
    /**
     * Sets the MessageHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sabre\OTAAirAvail\Structs\MessageHeader $messageHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderMessageHeader(\Sabre\OTAAirAvail\Structs\MessageHeader $messageHeader, $nameSpace = 'http://www.ebxml.org/namespaces/messageHeader', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'MessageHeader', $messageHeader, $mustUnderstand, $actor);
    }
    /**
     * Sets the Security SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \Sabre\OTAAirAvail\Structs\Security $security
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSecurity(\Sabre\OTAAirAvail\Structs\Security $security, $nameSpace = 'http://schemas.xmlsoap.org/ws/2002/12/secext', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Security', $security, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named OTA_AirAvailRQ
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: MessageHeader, Security
     * - SOAPHeaderNamespaces: http://www.ebxml.org/namespaces/messageHeader, http://schemas.xmlsoap.org/ws/2002/12/secext
     * - SOAPHeaderTypes: \Sabre\OTAAirAvail\Structs\MessageHeader, \Sabre\OTAAirAvail\Structs\Security
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Sabre\OTAAirAvail\Structs\OTA_AirAvailRQ $body
     * @return \Sabre\OTAAirAvail\Structs\OTA_AirAvailRS|bool
     */
    public function OTA_AirAvailRQ(\Sabre\OTAAirAvail\Structs\OTA_AirAvailRQ $body)
    {
        try {
            $this->setResult(self::getSoapClient()->OTA_AirAvailRQ($body));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Sabre\OTAAirAvail\Structs\OTA_AirAvailRS
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
