<?php

namespace Api\Aramex\Tracking\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrackingResult StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TrackingResult
 * @subpackage Structs
 */
class TrackingResult extends AbstractStructBase
{
    /**
     * The WaybillNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $WaybillNumber;
    /**
     * The UpdateCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UpdateCode;
    /**
     * The UpdateDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UpdateDescription;
    /**
     * The UpdateDateTime
     * @var string
     */
    public $UpdateDateTime;
    /**
     * The UpdateLocation
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UpdateLocation;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The ProblemCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ProblemCode;
    /**
     * Constructor method for TrackingResult
     * @uses TrackingResult::setWaybillNumber()
     * @uses TrackingResult::setUpdateCode()
     * @uses TrackingResult::setUpdateDescription()
     * @uses TrackingResult::setUpdateDateTime()
     * @uses TrackingResult::setUpdateLocation()
     * @uses TrackingResult::setComments()
     * @uses TrackingResult::setProblemCode()
     * @param string $waybillNumber
     * @param string $updateCode
     * @param string $updateDescription
     * @param string $updateDateTime
     * @param string $updateLocation
     * @param string $comments
     * @param string $problemCode
     */
    public function __construct($waybillNumber = null, $updateCode = null, $updateDescription = null, $updateDateTime = null, $updateLocation = null, $comments = null, $problemCode = null)
    {
        $this
            ->setWaybillNumber($waybillNumber)
            ->setUpdateCode($updateCode)
            ->setUpdateDescription($updateDescription)
            ->setUpdateDateTime($updateDateTime)
            ->setUpdateLocation($updateLocation)
            ->setComments($comments)
            ->setProblemCode($problemCode);
    }
    /**
     * Get WaybillNumber value
     * @return string|null
     */
    public function getWaybillNumber()
    {
        return $this->WaybillNumber;
    }
    /**
     * Set WaybillNumber value
     * @param string $waybillNumber
     * @return \Api\Aramex\Tracking\StructType\TrackingResult
     */
    public function setWaybillNumber($waybillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($waybillNumber) && !is_string($waybillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($waybillNumber)), __LINE__);
        }
        $this->WaybillNumber = $waybillNumber;
        return $this;
    }
    /**
     * Get UpdateCode value
     * @return string|null
     */
    public function getUpdateCode()
    {
        return $this->UpdateCode;
    }
    /**
     * Set UpdateCode value
     * @param string $updateCode
     * @return \Api\Aramex\Tracking\StructType\TrackingResult
     */
    public function setUpdateCode($updateCode = null)
    {
        // validation for constraint: string
        if (!is_null($updateCode) && !is_string($updateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateCode)), __LINE__);
        }
        $this->UpdateCode = $updateCode;
        return $this;
    }
    /**
     * Get UpdateDescription value
     * @return string|null
     */
    public function getUpdateDescription()
    {
        return $this->UpdateDescription;
    }
    /**
     * Set UpdateDescription value
     * @param string $updateDescription
     * @return \Api\Aramex\Tracking\StructType\TrackingResult
     */
    public function setUpdateDescription($updateDescription = null)
    {
        // validation for constraint: string
        if (!is_null($updateDescription) && !is_string($updateDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateDescription)), __LINE__);
        }
        $this->UpdateDescription = $updateDescription;
        return $this;
    }
    /**
     * Get UpdateDateTime value
     * @return string|null
     */
    public function getUpdateDateTime()
    {
        return $this->UpdateDateTime;
    }
    /**
     * Set UpdateDateTime value
     * @param string $updateDateTime
     * @return \Api\Aramex\Tracking\StructType\TrackingResult
     */
    public function setUpdateDateTime($updateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($updateDateTime) && !is_string($updateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateDateTime)), __LINE__);
        }
        $this->UpdateDateTime = $updateDateTime;
        return $this;
    }
    /**
     * Get UpdateLocation value
     * @return string|null
     */
    public function getUpdateLocation()
    {
        return $this->UpdateLocation;
    }
    /**
     * Set UpdateLocation value
     * @param string $updateLocation
     * @return \Api\Aramex\Tracking\StructType\TrackingResult
     */
    public function setUpdateLocation($updateLocation = null)
    {
        // validation for constraint: string
        if (!is_null($updateLocation) && !is_string($updateLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateLocation)), __LINE__);
        }
        $this->UpdateLocation = $updateLocation;
        return $this;
    }
    /**
     * Get Comments value
     * @return string|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param string $comments
     * @return \Api\Aramex\Tracking\StructType\TrackingResult
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comments)), __LINE__);
        }
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get ProblemCode value
     * @return string|null
     */
    public function getProblemCode()
    {
        return $this->ProblemCode;
    }
    /**
     * Set ProblemCode value
     * @param string $problemCode
     * @return \Api\Aramex\Tracking\StructType\TrackingResult
     */
    public function setProblemCode($problemCode = null)
    {
        // validation for constraint: string
        if (!is_null($problemCode) && !is_string($problemCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($problemCode)), __LINE__);
        }
        $this->ProblemCode = $problemCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Tracking\StructType\TrackingResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
