<?php

namespace Api\Aramex\Tracking\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientInfo
 * @subpackage Structs
 */
class ClientInfo extends AbstractStructBase
{
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Version;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The AccountPin
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountPin;
    /**
     * The AccountEntity
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountEntity;
    /**
     * The AccountCountryCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $AccountCountryCode;
    /**
     * Constructor method for ClientInfo
     * @uses ClientInfo::setUserName()
     * @uses ClientInfo::setPassword()
     * @uses ClientInfo::setVersion()
     * @uses ClientInfo::setAccountNumber()
     * @uses ClientInfo::setAccountPin()
     * @uses ClientInfo::setAccountEntity()
     * @uses ClientInfo::setAccountCountryCode()
     * @param string $userName
     * @param string $password
     * @param string $version
     * @param string $accountNumber
     * @param string $accountPin
     * @param string $accountEntity
     * @param string $accountCountryCode
     */
    public function __construct($userName = null, $password = null, $version = null, $accountNumber = null, $accountPin = null, $accountEntity = null, $accountCountryCode = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setVersion($version)
            ->setAccountNumber($accountNumber)
            ->setAccountPin($accountPin)
            ->setAccountEntity($accountEntity)
            ->setAccountCountryCode($accountCountryCode);
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \Api\Aramex\Tracking\StructType\ClientInfo
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \Api\Aramex\Tracking\StructType\ClientInfo
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \Api\Aramex\Tracking\StructType\ClientInfo
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Api\Aramex\Tracking\StructType\ClientInfo
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AccountPin value
     * @return string|null
     */
    public function getAccountPin()
    {
        return $this->AccountPin;
    }
    /**
     * Set AccountPin value
     * @param string $accountPin
     * @return \Api\Aramex\Tracking\StructType\ClientInfo
     */
    public function setAccountPin($accountPin = null)
    {
        // validation for constraint: string
        if (!is_null($accountPin) && !is_string($accountPin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountPin)), __LINE__);
        }
        $this->AccountPin = $accountPin;
        return $this;
    }
    /**
     * Get AccountEntity value
     * @return string|null
     */
    public function getAccountEntity()
    {
        return $this->AccountEntity;
    }
    /**
     * Set AccountEntity value
     * @param string $accountEntity
     * @return \Api\Aramex\Tracking\StructType\ClientInfo
     */
    public function setAccountEntity($accountEntity = null)
    {
        // validation for constraint: string
        if (!is_null($accountEntity) && !is_string($accountEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountEntity)), __LINE__);
        }
        $this->AccountEntity = $accountEntity;
        return $this;
    }
    /**
     * Get AccountCountryCode value
     * @return string|null
     */
    public function getAccountCountryCode()
    {
        return $this->AccountCountryCode;
    }
    /**
     * Set AccountCountryCode value
     * @param string $accountCountryCode
     * @return \Api\Aramex\Tracking\StructType\ClientInfo
     */
    public function setAccountCountryCode($accountCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCountryCode) && !is_string($accountCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountCountryCode)), __LINE__);
        }
        $this->AccountCountryCode = $accountCountryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Tracking\StructType\ClientInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
