<?php

namespace Api\Aramex\Tracking\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Track ServiceType
 * @subpackage Services
 */
class Track extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TrackShipments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Api\Aramex\Tracking\StructType\ShipmentTrackingRequest $parameters
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingResponse|bool
     */
    public function TrackShipments(\Api\Aramex\Tracking\StructType\ShipmentTrackingRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TrackShipments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
