<?php

namespace Api\Aramex\Tracking\ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTrackingResult ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTrackingResult
 * @subpackage Arrays
 */
class ArrayOfTrackingResult extends AbstractStructArrayBase
{
    /**
     * The TrackingResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Tracking\StructType\TrackingResult[]
     */
    public $TrackingResult;
    /**
     * Constructor method for ArrayOfTrackingResult
     * @uses ArrayOfTrackingResult::setTrackingResult()
     * @param \Api\Aramex\Tracking\StructType\TrackingResult[] $trackingResult
     */
    public function __construct(array $trackingResult = array())
    {
        $this
            ->setTrackingResult($trackingResult);
    }
    /**
     * Get TrackingResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Tracking\StructType\TrackingResult[]|null
     */
    public function getTrackingResult()
    {
        return isset($this->TrackingResult) ? $this->TrackingResult : null;
    }
    /**
     * Set TrackingResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Tracking\StructType\TrackingResult[] $trackingResult
     * @return \Api\Aramex\Tracking\ArrayType\ArrayOfTrackingResult
     */
    public function setTrackingResult(array $trackingResult = array())
    {
        foreach ($trackingResult as $arrayOfTrackingResultTrackingResultItem) {
            // validation for constraint: itemType
            if (!$arrayOfTrackingResultTrackingResultItem instanceof \Api\Aramex\Tracking\StructType\TrackingResult) {
                throw new \InvalidArgumentException(sprintf('The TrackingResult property can only contain items of \Api\Aramex\Tracking\StructType\TrackingResult, "%s" given', is_object($arrayOfTrackingResultTrackingResultItem) ? get_class($arrayOfTrackingResultTrackingResultItem) : gettype($arrayOfTrackingResultTrackingResultItem)), __LINE__);
            }
        }
        if (is_null($trackingResult) || (is_array($trackingResult) && empty($trackingResult))) {
            unset($this->TrackingResult);
        } else {
            $this->TrackingResult = $trackingResult;
        }
        return $this;
    }
    /**
     * Add item to TrackingResult value
     * @throws \InvalidArgumentException
     * @param \Api\Aramex\Tracking\StructType\TrackingResult $item
     * @return \Api\Aramex\Tracking\ArrayType\ArrayOfTrackingResult
     */
    public function addToTrackingResult(\Api\Aramex\Tracking\StructType\TrackingResult $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Api\Aramex\Tracking\StructType\TrackingResult) {
            throw new \InvalidArgumentException(sprintf('The TrackingResult property can only contain items of \Api\Aramex\Tracking\StructType\TrackingResult, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TrackingResult[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Api\Aramex\Tracking\StructType\TrackingResult|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Api\Aramex\Tracking\StructType\TrackingResult|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Api\Aramex\Tracking\StructType\TrackingResult|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Api\Aramex\Tracking\StructType\TrackingResult|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Api\Aramex\Tracking\StructType\TrackingResult|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TrackingResult
     */
    public function getAttributeName()
    {
        return 'TrackingResult';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Tracking\ArrayType\ArrayOfTrackingResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
