<?php

namespace Api\Aramex\Tracking\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentTrackingResponse StructType
 * @subpackage Structs
 */
class ShipmentTrackingResponse extends AbstractStructBase
{
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Tracking\StructType\Transaction
     */
    public $Transaction;
    /**
     * The Notifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Tracking\ArrayType\ArrayOfNotification
     */
    public $Notifications;
    /**
     * The HasErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasErrors;
    /**
     * The TrackingResults
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Tracking\ArrayType\ArrayOfKeyValueOfstringArrayOfTrackingResultmFAkxlpY
     */
    public $TrackingResults;
    /**
     * Constructor method for ShipmentTrackingResponse
     * @uses ShipmentTrackingResponse::setTransaction()
     * @uses ShipmentTrackingResponse::setNotifications()
     * @uses ShipmentTrackingResponse::setHasErrors()
     * @uses ShipmentTrackingResponse::setTrackingResults()
     * @param \Api\Aramex\Tracking\StructType\Transaction $transaction
     * @param \Api\Aramex\Tracking\ArrayType\ArrayOfNotification $notifications
     * @param bool $hasErrors
     * @param \Api\Aramex\Tracking\ArrayType\ArrayOfKeyValueOfstringArrayOfTrackingResultmFAkxlpY $trackingResults
     */
    public function __construct(\Api\Aramex\Tracking\StructType\Transaction $transaction = null, \Api\Aramex\Tracking\ArrayType\ArrayOfNotification $notifications = null, $hasErrors = null, \Api\Aramex\Tracking\ArrayType\ArrayOfKeyValueOfstringArrayOfTrackingResultmFAkxlpY $trackingResults = null)
    {
        $this
            ->setTransaction($transaction)
            ->setNotifications($notifications)
            ->setHasErrors($hasErrors)
            ->setTrackingResults($trackingResults);
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Tracking\StructType\Transaction|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Tracking\StructType\Transaction $transaction
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingResponse
     */
    public function setTransaction(\Api\Aramex\Tracking\StructType\Transaction $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get Notifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Tracking\ArrayType\ArrayOfNotification|null
     */
    public function getNotifications()
    {
        return isset($this->Notifications) ? $this->Notifications : null;
    }
    /**
     * Set Notifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Tracking\ArrayType\ArrayOfNotification $notifications
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingResponse
     */
    public function setNotifications(\Api\Aramex\Tracking\ArrayType\ArrayOfNotification $notifications = null)
    {
        if (is_null($notifications) || (is_array($notifications) && empty($notifications))) {
            unset($this->Notifications);
        } else {
            $this->Notifications = $notifications;
        }
        return $this;
    }
    /**
     * Get HasErrors value
     * @return bool|null
     */
    public function getHasErrors()
    {
        return $this->HasErrors;
    }
    /**
     * Set HasErrors value
     * @param bool $hasErrors
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingResponse
     */
    public function setHasErrors($hasErrors = null)
    {
        $this->HasErrors = $hasErrors;
        return $this;
    }
    /**
     * Get TrackingResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Tracking\ArrayType\ArrayOfKeyValueOfstringArrayOfTrackingResultmFAkxlpY|null
     */
    public function getTrackingResults()
    {
        return isset($this->TrackingResults) ? $this->TrackingResults : null;
    }
    /**
     * Set TrackingResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Tracking\ArrayType\ArrayOfKeyValueOfstringArrayOfTrackingResultmFAkxlpY $trackingResults
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingResponse
     */
    public function setTrackingResults(\Api\Aramex\Tracking\ArrayType\ArrayOfKeyValueOfstringArrayOfTrackingResultmFAkxlpY $trackingResults = null)
    {
        if (is_null($trackingResults) || (is_array($trackingResults) && empty($trackingResults))) {
            unset($this->TrackingResults);
        } else {
            $this->TrackingResults = $trackingResults;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
