<?php

namespace Api\Aramex\Tracking\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentTrackingRequest StructType
 * @subpackage Structs
 */
class ShipmentTrackingRequest extends AbstractStructBase
{
    /**
     * The ClientInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Tracking\StructType\ClientInfo
     */
    public $ClientInfo;
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Tracking\StructType\Transaction
     */
    public $Transaction;
    /**
     * The Shipments
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Tracking\ArrayType\ArrayOfstring
     */
    public $Shipments;
    /**
     * The GetLastTrackingUpdateOnly
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetLastTrackingUpdateOnly;
    /**
     * Constructor method for ShipmentTrackingRequest
     * @uses ShipmentTrackingRequest::setClientInfo()
     * @uses ShipmentTrackingRequest::setTransaction()
     * @uses ShipmentTrackingRequest::setShipments()
     * @uses ShipmentTrackingRequest::setGetLastTrackingUpdateOnly()
     * @param \Api\Aramex\Tracking\StructType\ClientInfo $clientInfo
     * @param \Api\Aramex\Tracking\StructType\Transaction $transaction
     * @param \Api\Aramex\Tracking\ArrayType\ArrayOfstring $shipments
     * @param bool $getLastTrackingUpdateOnly
     */
    public function __construct(\Api\Aramex\Tracking\StructType\ClientInfo $clientInfo = null, \Api\Aramex\Tracking\StructType\Transaction $transaction = null, \Api\Aramex\Tracking\ArrayType\ArrayOfstring $shipments = null, $getLastTrackingUpdateOnly = null)
    {
        $this
            ->setClientInfo($clientInfo)
            ->setTransaction($transaction)
            ->setShipments($shipments)
            ->setGetLastTrackingUpdateOnly($getLastTrackingUpdateOnly);
    }
    /**
     * Get ClientInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Tracking\StructType\ClientInfo|null
     */
    public function getClientInfo()
    {
        return isset($this->ClientInfo) ? $this->ClientInfo : null;
    }
    /**
     * Set ClientInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Tracking\StructType\ClientInfo $clientInfo
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingRequest
     */
    public function setClientInfo(\Api\Aramex\Tracking\StructType\ClientInfo $clientInfo = null)
    {
        if (is_null($clientInfo) || (is_array($clientInfo) && empty($clientInfo))) {
            unset($this->ClientInfo);
        } else {
            $this->ClientInfo = $clientInfo;
        }
        return $this;
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Tracking\StructType\Transaction|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Tracking\StructType\Transaction $transaction
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingRequest
     */
    public function setTransaction(\Api\Aramex\Tracking\StructType\Transaction $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get Shipments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Tracking\ArrayType\ArrayOfstring|null
     */
    public function getShipments()
    {
        return isset($this->Shipments) ? $this->Shipments : null;
    }
    /**
     * Set Shipments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Tracking\ArrayType\ArrayOfstring $shipments
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingRequest
     */
    public function setShipments(\Api\Aramex\Tracking\ArrayType\ArrayOfstring $shipments = null)
    {
        if (is_null($shipments) || (is_array($shipments) && empty($shipments))) {
            unset($this->Shipments);
        } else {
            $this->Shipments = $shipments;
        }
        return $this;
    }
    /**
     * Get GetLastTrackingUpdateOnly value
     * @return bool|null
     */
    public function getGetLastTrackingUpdateOnly()
    {
        return $this->GetLastTrackingUpdateOnly;
    }
    /**
     * Set GetLastTrackingUpdateOnly value
     * @param bool $getLastTrackingUpdateOnly
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingRequest
     */
    public function setGetLastTrackingUpdateOnly($getLastTrackingUpdateOnly = null)
    {
        $this->GetLastTrackingUpdateOnly = $getLastTrackingUpdateOnly;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Tracking\StructType\ShipmentTrackingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
