<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketingInfo Structs
 * @subpackage Structs
 */
class TicketingInfo extends AbstractStructBase
{
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Ticketing[]
     */
    public $Ticketing;
    /**
     * Constructor method for TicketingInfo
     * @uses TicketingInfo::setTicketing()
     * @param \Sabre\OTAAirPrice\Structs\Ticketing[] $ticketing
     */
    public function __construct(array $ticketing = array())
    {
        $this
            ->setTicketing($ticketing);
    }
    /**
     * Get Ticketing value
     * @return \Sabre\OTAAirPrice\Structs\Ticketing[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Ticketing[] $ticketing
     * @return \Sabre\OTAAirPrice\Structs\TicketingInfo
     */
    public function setTicketing(array $ticketing = array())
    {
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Ticketing $item
     * @return \Sabre\OTAAirPrice\Structs\TicketingInfo
     */
    public function addToTicketing(\Sabre\OTAAirPrice\Structs\Ticketing $item)
    {
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\TicketingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
