<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing Structs
 * @subpackage Structs
 */
class Ticketing extends AbstractStructBase
{
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $LocationCode;
    /**
     * The EndNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $EndNumber;
    /**
     * The eTicketNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $eTicketNumber;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Number;
    /**
     * The Coupon
     * Meta informations extracted from the WSDL
     * - maxOccurs: 16
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Coupon[]
     */
    public $Coupon;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\PersonName
     */
    public $PersonName;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReferenceNumber;
    /**
     * Constructor method for Ticketing
     * @uses Ticketing::setLocationCode()
     * @uses Ticketing::setEndNumber()
     * @uses Ticketing::setETicketNumber()
     * @uses Ticketing::setNumber()
     * @uses Ticketing::setCoupon()
     * @uses Ticketing::setPersonName()
     * @uses Ticketing::setReferenceNumber()
     * @param string $locationCode
     * @param int $endNumber
     * @param int $eTicketNumber
     * @param int $number
     * @param \Sabre\OTAAirPrice\Structs\Coupon[] $coupon
     * @param \Sabre\OTAAirPrice\Structs\PersonName $personName
     * @param string $referenceNumber
     */
    public function __construct($locationCode = null, $endNumber = null, $eTicketNumber = null, $number = null, array $coupon = array(), \Sabre\OTAAirPrice\Structs\PersonName $personName = null, $referenceNumber = null)
    {
        $this
            ->setLocationCode($locationCode)
            ->setEndNumber($endNumber)
            ->setETicketNumber($eTicketNumber)
            ->setNumber($number)
            ->setCoupon($coupon)
            ->setPersonName($personName)
            ->setReferenceNumber($referenceNumber);
    }
    /**
     * Get LocationCode value
     * @return string
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\OTAAirPrice\Structs\Ticketing
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get EndNumber value
     * @return int|null
     */
    public function getEndNumber()
    {
        return $this->EndNumber;
    }
    /**
     * Set EndNumber value
     * @param int $endNumber
     * @return \Sabre\OTAAirPrice\Structs\Ticketing
     */
    public function setEndNumber($endNumber = null)
    {
        $this->EndNumber = $endNumber;
        return $this;
    }
    /**
     * Get eTicketNumber value
     * @return int|null
     */
    public function getETicketNumber()
    {
        return $this->eTicketNumber;
    }
    /**
     * Set eTicketNumber value
     * @param int $eTicketNumber
     * @return \Sabre\OTAAirPrice\Structs\Ticketing
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        $this->eTicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get Number value
     * @return int|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \Sabre\OTAAirPrice\Structs\Ticketing
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Coupon value
     * @return \Sabre\OTAAirPrice\Structs\Coupon[]|null
     */
    public function getCoupon()
    {
        return $this->Coupon;
    }
    /**
     * Set Coupon value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Coupon[] $coupon
     * @return \Sabre\OTAAirPrice\Structs\Ticketing
     */
    public function setCoupon(array $coupon = array())
    {
        $this->Coupon = $coupon;
        return $this;
    }
    /**
     * Add item to Coupon value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Coupon $item
     * @return \Sabre\OTAAirPrice\Structs\Ticketing
     */
    public function addToCoupon(\Sabre\OTAAirPrice\Structs\Coupon $item)
    {
        $this->Coupon[] = $item;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\OTAAirPrice\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\OTAAirPrice\Structs\PersonName $personName
     * @return \Sabre\OTAAirPrice\Structs\Ticketing
     */
    public function setPersonName(\Sabre\OTAAirPrice\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \Sabre\OTAAirPrice\Structs\Ticketing
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\Ticketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
