<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxBreakDown Structs
 * @subpackage Structs
 */
class TaxBreakDown extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The AmountPublished
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AmountPublished;
    /**
     * The PublishedCurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PublishedCurrencyCode;
    /**
     * The StationCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $StationCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * The GoodAndServicesInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $GoodAndServicesInd;
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AirlineCode;
    /**
     * The TaxType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TaxType;
    /**
     * Constructor method for TaxBreakDown
     * @uses TaxBreakDown::setCode()
     * @uses TaxBreakDown::setDescription()
     * @uses TaxBreakDown::setAmount()
     * @uses TaxBreakDown::setCurrencyCode()
     * @uses TaxBreakDown::setAmountPublished()
     * @uses TaxBreakDown::setPublishedCurrencyCode()
     * @uses TaxBreakDown::setStationCode()
     * @uses TaxBreakDown::setCountryCode()
     * @uses TaxBreakDown::setGoodAndServicesInd()
     * @uses TaxBreakDown::setAirlineCode()
     * @uses TaxBreakDown::setTaxType()
     * @param string $code
     * @param string $description
     * @param string $amount
     * @param string $currencyCode
     * @param string $amountPublished
     * @param string $publishedCurrencyCode
     * @param string $stationCode
     * @param string $countryCode
     * @param bool $goodAndServicesInd
     * @param string $airlineCode
     * @param string $taxType
     */
    public function __construct($code = null, $description = null, $amount = null, $currencyCode = null, $amountPublished = null, $publishedCurrencyCode = null, $stationCode = null, $countryCode = null, $goodAndServicesInd = null, $airlineCode = null, $taxType = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setAmountPublished($amountPublished)
            ->setPublishedCurrencyCode($publishedCurrencyCode)
            ->setStationCode($stationCode)
            ->setCountryCode($countryCode)
            ->setGoodAndServicesInd($goodAndServicesInd)
            ->setAirlineCode($airlineCode)
            ->setTaxType($taxType);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get AmountPublished value
     * @return string|null
     */
    public function getAmountPublished()
    {
        return $this->AmountPublished;
    }
    /**
     * Set AmountPublished value
     * @param string $amountPublished
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setAmountPublished($amountPublished = null)
    {
        $this->AmountPublished = $amountPublished;
        return $this;
    }
    /**
     * Get PublishedCurrencyCode value
     * @return string|null
     */
    public function getPublishedCurrencyCode()
    {
        return $this->PublishedCurrencyCode;
    }
    /**
     * Set PublishedCurrencyCode value
     * @param string $publishedCurrencyCode
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setPublishedCurrencyCode($publishedCurrencyCode = null)
    {
        $this->PublishedCurrencyCode = $publishedCurrencyCode;
        return $this;
    }
    /**
     * Get StationCode value
     * @return string|null
     */
    public function getStationCode()
    {
        return $this->StationCode;
    }
    /**
     * Set StationCode value
     * @param string $stationCode
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setStationCode($stationCode = null)
    {
        $this->StationCode = $stationCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setCountryCode($countryCode = null)
    {
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get GoodAndServicesInd value
     * @return bool|null
     */
    public function getGoodAndServicesInd()
    {
        return $this->GoodAndServicesInd;
    }
    /**
     * Set GoodAndServicesInd value
     * @param bool $goodAndServicesInd
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setGoodAndServicesInd($goodAndServicesInd = null)
    {
        $this->GoodAndServicesInd = $goodAndServicesInd;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get TaxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @param string $taxType
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public function setTaxType($taxType = null)
    {
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\TaxBreakDown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
