<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultSummary Structs
 * Meta informations extracted from the WSDL
 * - type: ResultSummary
 * @subpackage Structs
 */
class ResultSummary extends AbstractStructBase
{
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - documentation: Success indicates that the request was processed successfully. | Elements of this type are used for indicators whose presense denotes the condition described by their name. They have no content nor any attributes. For example, an
     * empty Success element denote that the process was successfully completed.
     * - maxLength: 0
     * @var string
     */
    public $Success;
    /**
     * The Error
     * @var \Sabre\OTAAirPrice\Structs\ProblemSummary
     */
    public $Error;
    /**
     * Constructor method for ResultSummary
     * @uses ResultSummary::setSuccess()
     * @uses ResultSummary::setError()
     * @param string $success
     * @param \Sabre\OTAAirPrice\Structs\ProblemSummary $error
     */
    public function __construct($success = null, \Sabre\OTAAirPrice\Structs\ProblemSummary $error = null)
    {
        $this
            ->setSuccess($success)
            ->setError($error);
    }
    /**
     * Get Success value
     * @return string|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param string $success
     * @return \Sabre\OTAAirPrice\Structs\ResultSummary
     */
    public function setSuccess($success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get Error value
     * @return \Sabre\OTAAirPrice\Structs\ProblemSummary|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param \Sabre\OTAAirPrice\Structs\ProblemSummary $error
     * @return \Sabre\OTAAirPrice\Structs\ResultSummary
     */
    public function setError(\Sabre\OTAAirPrice\Structs\ProblemSummary $error = null)
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\ResultSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
