<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PricedItinerary Structs
 * @subpackage Structs
 */
class PricedItinerary extends AbstractStructBase
{
    /**
     * The AirItineraryPricingInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo[]
     */
    public $AirItineraryPricingInfo;
    /**
     * The AlternativePricing
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AlternativePricing;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The MultiTicket
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $MultiTicket;
    /**
     * The MultiTicketShortText
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MultiTicketShortText;
    /**
     * The ServiceFeeAmount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ServiceFeeAmount;
    /**
     * The ServiceFeeCurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ServiceFeeCurrencyCode;
    /**
     * The ServiceFeeTax
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ServiceFeeTax;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TotalAmount;
    /**
     * Constructor method for PricedItinerary
     * @uses PricedItinerary::setAirItineraryPricingInfo()
     * @uses PricedItinerary::setAlternativePricing()
     * @uses PricedItinerary::setCurrencyCode()
     * @uses PricedItinerary::setMultiTicket()
     * @uses PricedItinerary::setMultiTicketShortText()
     * @uses PricedItinerary::setServiceFeeAmount()
     * @uses PricedItinerary::setServiceFeeCurrencyCode()
     * @uses PricedItinerary::setServiceFeeTax()
     * @uses PricedItinerary::setTotalAmount()
     * @param \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo[] $airItineraryPricingInfo
     * @param string $alternativePricing
     * @param string $currencyCode
     * @param bool $multiTicket
     * @param string $multiTicketShortText
     * @param string $serviceFeeAmount
     * @param string $serviceFeeCurrencyCode
     * @param string $serviceFeeTax
     * @param string $totalAmount
     */
    public function __construct(array $airItineraryPricingInfo = array(), $alternativePricing = null, $currencyCode = null, $multiTicket = null, $multiTicketShortText = null, $serviceFeeAmount = null, $serviceFeeCurrencyCode = null, $serviceFeeTax = null, $totalAmount = null)
    {
        $this
            ->setAirItineraryPricingInfo($airItineraryPricingInfo)
            ->setAlternativePricing($alternativePricing)
            ->setCurrencyCode($currencyCode)
            ->setMultiTicket($multiTicket)
            ->setMultiTicketShortText($multiTicketShortText)
            ->setServiceFeeAmount($serviceFeeAmount)
            ->setServiceFeeCurrencyCode($serviceFeeCurrencyCode)
            ->setServiceFeeTax($serviceFeeTax)
            ->setTotalAmount($totalAmount);
    }
    /**
     * Get AirItineraryPricingInfo value
     * @return \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo[]|null
     */
    public function getAirItineraryPricingInfo()
    {
        return $this->AirItineraryPricingInfo;
    }
    /**
     * Set AirItineraryPricingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo[] $airItineraryPricingInfo
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function setAirItineraryPricingInfo(array $airItineraryPricingInfo = array())
    {
        $this->AirItineraryPricingInfo = $airItineraryPricingInfo;
        return $this;
    }
    /**
     * Add item to AirItineraryPricingInfo value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo $item
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function addToAirItineraryPricingInfo(\Sabre\OTAAirPrice\Structs\AirItineraryPricingInfo $item)
    {
        $this->AirItineraryPricingInfo[] = $item;
        return $this;
    }
    /**
     * Get AlternativePricing value
     * @return string|null
     */
    public function getAlternativePricing()
    {
        return $this->AlternativePricing;
    }
    /**
     * Set AlternativePricing value
     * @param string $alternativePricing
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function setAlternativePricing($alternativePricing = null)
    {
        $this->AlternativePricing = $alternativePricing;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get MultiTicket value
     * @return bool|null
     */
    public function getMultiTicket()
    {
        return $this->MultiTicket;
    }
    /**
     * Set MultiTicket value
     * @param bool $multiTicket
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function setMultiTicket($multiTicket = null)
    {
        $this->MultiTicket = $multiTicket;
        return $this;
    }
    /**
     * Get MultiTicketShortText value
     * @return string|null
     */
    public function getMultiTicketShortText()
    {
        return $this->MultiTicketShortText;
    }
    /**
     * Set MultiTicketShortText value
     * @param string $multiTicketShortText
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function setMultiTicketShortText($multiTicketShortText = null)
    {
        $this->MultiTicketShortText = $multiTicketShortText;
        return $this;
    }
    /**
     * Get ServiceFeeAmount value
     * @return string|null
     */
    public function getServiceFeeAmount()
    {
        return $this->ServiceFeeAmount;
    }
    /**
     * Set ServiceFeeAmount value
     * @param string $serviceFeeAmount
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function setServiceFeeAmount($serviceFeeAmount = null)
    {
        $this->ServiceFeeAmount = $serviceFeeAmount;
        return $this;
    }
    /**
     * Get ServiceFeeCurrencyCode value
     * @return string|null
     */
    public function getServiceFeeCurrencyCode()
    {
        return $this->ServiceFeeCurrencyCode;
    }
    /**
     * Set ServiceFeeCurrencyCode value
     * @param string $serviceFeeCurrencyCode
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function setServiceFeeCurrencyCode($serviceFeeCurrencyCode = null)
    {
        $this->ServiceFeeCurrencyCode = $serviceFeeCurrencyCode;
        return $this;
    }
    /**
     * Get ServiceFeeTax value
     * @return string|null
     */
    public function getServiceFeeTax()
    {
        return $this->ServiceFeeTax;
    }
    /**
     * Set ServiceFeeTax value
     * @param string $serviceFeeTax
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function setServiceFeeTax($serviceFeeTax = null)
    {
        $this->ServiceFeeTax = $serviceFeeTax;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param string $totalAmount
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\PricedItinerary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
