<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionalCharges Structs
 * @subpackage Structs
 */
class OptionalCharges extends AbstractStructBase
{
    /**
     * The ChargeDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ChargeDetails
     */
    public $ChargeDetails;
    /**
     * The ItineraryInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\ItineraryInfo
     */
    public $ItineraryInfo;
    /**
     * The TicketingInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\TicketingInfo
     */
    public $TicketingInfo;
    /**
     * The SolutionSequenceNmbr
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SolutionSequenceNmbr;
    /**
     * Constructor method for OptionalCharges
     * @uses OptionalCharges::setChargeDetails()
     * @uses OptionalCharges::setItineraryInfo()
     * @uses OptionalCharges::setTicketingInfo()
     * @uses OptionalCharges::setSolutionSequenceNmbr()
     * @param \Sabre\OTAAirPrice\Structs\ChargeDetails $chargeDetails
     * @param \Sabre\OTAAirPrice\Structs\ItineraryInfo $itineraryInfo
     * @param \Sabre\OTAAirPrice\Structs\TicketingInfo $ticketingInfo
     * @param string $solutionSequenceNmbr
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\ChargeDetails $chargeDetails = null, \Sabre\OTAAirPrice\Structs\ItineraryInfo $itineraryInfo = null, \Sabre\OTAAirPrice\Structs\TicketingInfo $ticketingInfo = null, $solutionSequenceNmbr = null)
    {
        $this
            ->setChargeDetails($chargeDetails)
            ->setItineraryInfo($itineraryInfo)
            ->setTicketingInfo($ticketingInfo)
            ->setSolutionSequenceNmbr($solutionSequenceNmbr);
    }
    /**
     * Get ChargeDetails value
     * @return \Sabre\OTAAirPrice\Structs\ChargeDetails|null
     */
    public function getChargeDetails()
    {
        return $this->ChargeDetails;
    }
    /**
     * Set ChargeDetails value
     * @param \Sabre\OTAAirPrice\Structs\ChargeDetails $chargeDetails
     * @return \Sabre\OTAAirPrice\Structs\OptionalCharges
     */
    public function setChargeDetails(\Sabre\OTAAirPrice\Structs\ChargeDetails $chargeDetails = null)
    {
        $this->ChargeDetails = $chargeDetails;
        return $this;
    }
    /**
     * Get ItineraryInfo value
     * @return \Sabre\OTAAirPrice\Structs\ItineraryInfo|null
     */
    public function getItineraryInfo()
    {
        return $this->ItineraryInfo;
    }
    /**
     * Set ItineraryInfo value
     * @param \Sabre\OTAAirPrice\Structs\ItineraryInfo $itineraryInfo
     * @return \Sabre\OTAAirPrice\Structs\OptionalCharges
     */
    public function setItineraryInfo(\Sabre\OTAAirPrice\Structs\ItineraryInfo $itineraryInfo = null)
    {
        $this->ItineraryInfo = $itineraryInfo;
        return $this;
    }
    /**
     * Get TicketingInfo value
     * @return \Sabre\OTAAirPrice\Structs\TicketingInfo|null
     */
    public function getTicketingInfo()
    {
        return $this->TicketingInfo;
    }
    /**
     * Set TicketingInfo value
     * @param \Sabre\OTAAirPrice\Structs\TicketingInfo $ticketingInfo
     * @return \Sabre\OTAAirPrice\Structs\OptionalCharges
     */
    public function setTicketingInfo(\Sabre\OTAAirPrice\Structs\TicketingInfo $ticketingInfo = null)
    {
        $this->TicketingInfo = $ticketingInfo;
        return $this;
    }
    /**
     * Get SolutionSequenceNmbr value
     * @return string|null
     */
    public function getSolutionSequenceNmbr()
    {
        return $this->SolutionSequenceNmbr;
    }
    /**
     * Set SolutionSequenceNmbr value
     * @param string $solutionSequenceNmbr
     * @return \Sabre\OTAAirPrice\Structs\OptionalCharges
     */
    public function setSolutionSequenceNmbr($solutionSequenceNmbr = null)
    {
        $this->SolutionSequenceNmbr = $solutionSequenceNmbr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\OptionalCharges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
