<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageData Structs
 * @subpackage Structs
 */
class MessageData extends AbstractStructBase
{
    /**
     * The MessageId
     * Meta informations extracted from the WSDL
     * - ref: tns:MessageId
     * - minLength: 1
     * @var string
     */
    public $MessageId;
    /**
     * The Timestamp
     * Meta informations extracted from the WSDL
     * - ref: tns:Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The RefToMessageId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:RefToMessageId
     * - minLength: 1
     * @var string
     */
    public $RefToMessageId;
    /**
     * The TimeToLive
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:TimeToLive
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TimeToLive;
    /**
     * The Timeout
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Timeout
     * @var int
     */
    public $Timeout;
    /**
     * Constructor method for MessageData
     * @uses MessageData::setMessageId()
     * @uses MessageData::setTimestamp()
     * @uses MessageData::setRefToMessageId()
     * @uses MessageData::setTimeToLive()
     * @uses MessageData::setTimeout()
     * @param string $messageId
     * @param string $timestamp
     * @param string $refToMessageId
     * @param string $timeToLive
     * @param int $timeout
     */
    public function __construct($messageId = null, $timestamp = null, $refToMessageId = null, $timeToLive = null, $timeout = null)
    {
        $this
            ->setMessageId($messageId)
            ->setTimestamp($timestamp)
            ->setRefToMessageId($refToMessageId)
            ->setTimeToLive($timeToLive)
            ->setTimeout($timeout);
    }
    /**
     * Get MessageId value
     * @return string|null
     */
    public function getMessageId()
    {
        return $this->MessageId;
    }
    /**
     * Set MessageId value
     * @param string $messageId
     * @return \Sabre\OTAAirPrice\Structs\MessageData
     */
    public function setMessageId($messageId = null)
    {
        $this->MessageId = $messageId;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \Sabre\OTAAirPrice\Structs\MessageData
     */
    public function setTimestamp($timestamp = null)
    {
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get RefToMessageId value
     * @return string|null
     */
    public function getRefToMessageId()
    {
        return $this->RefToMessageId;
    }
    /**
     * Set RefToMessageId value
     * @param string $refToMessageId
     * @return \Sabre\OTAAirPrice\Structs\MessageData
     */
    public function setRefToMessageId($refToMessageId = null)
    {
        $this->RefToMessageId = $refToMessageId;
        return $this;
    }
    /**
     * Get TimeToLive value
     * @return string|null
     */
    public function getTimeToLive()
    {
        return $this->TimeToLive;
    }
    /**
     * Set TimeToLive value
     * @param string $timeToLive
     * @return \Sabre\OTAAirPrice\Structs\MessageData
     */
    public function setTimeToLive($timeToLive = null)
    {
        $this->TimeToLive = $timeToLive;
        return $this;
    }
    /**
     * Get Timeout value
     * @return int|null
     */
    public function getTimeout()
    {
        return $this->Timeout;
    }
    /**
     * Set Timeout value
     * @param int $timeout
     * @return \Sabre\OTAAirPrice\Structs\MessageData
     */
    public function setTimeout($timeout = null)
    {
        $this->Timeout = $timeout;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\MessageData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
