<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareCalculationBreakdown Structs
 * @subpackage Structs
 */
class FareCalculationBreakdown extends AbstractStructBase
{
    /**
     * The Branch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Branch
     */
    public $Branch;
    /**
     * The Departure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Departure
     */
    public $Departure;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\FareBasis
     */
    public $FareBasis;
    /**
     * The FreeBaggageAllowance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FreeBaggageAllowance;
    /**
     * The Mileage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Mileage
     */
    public $Mileage;
    /**
     * The RuleCategoryIndicator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 28
     * - minOccurs: 0
     * @var string[]
     */
    public $RuleCategoryIndicator;
    /**
     * The Surcharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\Surcharges[]
     */
    public $Surcharges;
    /**
     * The StopoverCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\OTAAirPrice\Structs\StopoverCharge
     */
    public $StopoverCharge;
    /**
     * Constructor method for FareCalculationBreakdown
     * @uses FareCalculationBreakdown::setBranch()
     * @uses FareCalculationBreakdown::setDeparture()
     * @uses FareCalculationBreakdown::setFareBasis()
     * @uses FareCalculationBreakdown::setFreeBaggageAllowance()
     * @uses FareCalculationBreakdown::setMileage()
     * @uses FareCalculationBreakdown::setRuleCategoryIndicator()
     * @uses FareCalculationBreakdown::setSurcharges()
     * @uses FareCalculationBreakdown::setStopoverCharge()
     * @param \Sabre\OTAAirPrice\Structs\Branch $branch
     * @param \Sabre\OTAAirPrice\Structs\Departure $departure
     * @param \Sabre\OTAAirPrice\Structs\FareBasis $fareBasis
     * @param string $freeBaggageAllowance
     * @param \Sabre\OTAAirPrice\Structs\Mileage $mileage
     * @param string[] $ruleCategoryIndicator
     * @param \Sabre\OTAAirPrice\Structs\Surcharges[] $surcharges
     * @param \Sabre\OTAAirPrice\Structs\StopoverCharge $stopoverCharge
     */
    public function __construct(\Sabre\OTAAirPrice\Structs\Branch $branch = null, \Sabre\OTAAirPrice\Structs\Departure $departure = null, \Sabre\OTAAirPrice\Structs\FareBasis $fareBasis = null, $freeBaggageAllowance = null, \Sabre\OTAAirPrice\Structs\Mileage $mileage = null, array $ruleCategoryIndicator = array(), array $surcharges = array(), \Sabre\OTAAirPrice\Structs\StopoverCharge $stopoverCharge = null)
    {
        $this
            ->setBranch($branch)
            ->setDeparture($departure)
            ->setFareBasis($fareBasis)
            ->setFreeBaggageAllowance($freeBaggageAllowance)
            ->setMileage($mileage)
            ->setRuleCategoryIndicator($ruleCategoryIndicator)
            ->setSurcharges($surcharges)
            ->setStopoverCharge($stopoverCharge);
    }
    /**
     * Get Branch value
     * @return \Sabre\OTAAirPrice\Structs\Branch|null
     */
    public function getBranch()
    {
        return $this->Branch;
    }
    /**
     * Set Branch value
     * @param \Sabre\OTAAirPrice\Structs\Branch $branch
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function setBranch(\Sabre\OTAAirPrice\Structs\Branch $branch = null)
    {
        $this->Branch = $branch;
        return $this;
    }
    /**
     * Get Departure value
     * @return \Sabre\OTAAirPrice\Structs\Departure|null
     */
    public function getDeparture()
    {
        return $this->Departure;
    }
    /**
     * Set Departure value
     * @param \Sabre\OTAAirPrice\Structs\Departure $departure
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function setDeparture(\Sabre\OTAAirPrice\Structs\Departure $departure = null)
    {
        $this->Departure = $departure;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return \Sabre\OTAAirPrice\Structs\FareBasis|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param \Sabre\OTAAirPrice\Structs\FareBasis $fareBasis
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function setFareBasis(\Sabre\OTAAirPrice\Structs\FareBasis $fareBasis = null)
    {
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get FreeBaggageAllowance value
     * @return string|null
     */
    public function getFreeBaggageAllowance()
    {
        return $this->FreeBaggageAllowance;
    }
    /**
     * Set FreeBaggageAllowance value
     * @param string $freeBaggageAllowance
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function setFreeBaggageAllowance($freeBaggageAllowance = null)
    {
        $this->FreeBaggageAllowance = $freeBaggageAllowance;
        return $this;
    }
    /**
     * Get Mileage value
     * @return \Sabre\OTAAirPrice\Structs\Mileage|null
     */
    public function getMileage()
    {
        return $this->Mileage;
    }
    /**
     * Set Mileage value
     * @param \Sabre\OTAAirPrice\Structs\Mileage $mileage
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function setMileage(\Sabre\OTAAirPrice\Structs\Mileage $mileage = null)
    {
        $this->Mileage = $mileage;
        return $this;
    }
    /**
     * Get RuleCategoryIndicator value
     * @return string[]|null
     */
    public function getRuleCategoryIndicator()
    {
        return $this->RuleCategoryIndicator;
    }
    /**
     * Set RuleCategoryIndicator value
     * @throws \InvalidArgumentException
     * @param string[] $ruleCategoryIndicator
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function setRuleCategoryIndicator(array $ruleCategoryIndicator = array())
    {
        $this->RuleCategoryIndicator = $ruleCategoryIndicator;
        return $this;
    }
    /**
     * Add item to RuleCategoryIndicator value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function addToRuleCategoryIndicator($item)
    {
        $this->RuleCategoryIndicator[] = $item;
        return $this;
    }
    /**
     * Get Surcharges value
     * @return \Sabre\OTAAirPrice\Structs\Surcharges[]|null
     */
    public function getSurcharges()
    {
        return $this->Surcharges;
    }
    /**
     * Set Surcharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Surcharges[] $surcharges
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function setSurcharges(array $surcharges = array())
    {
        $this->Surcharges = $surcharges;
        return $this;
    }
    /**
     * Add item to Surcharges value
     * @throws \InvalidArgumentException
     * @param \Sabre\OTAAirPrice\Structs\Surcharges $item
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function addToSurcharges(\Sabre\OTAAirPrice\Structs\Surcharges $item)
    {
        $this->Surcharges[] = $item;
        return $this;
    }
    /**
     * Get StopoverCharge value
     * @return \Sabre\OTAAirPrice\Structs\StopoverCharge|null
     */
    public function getStopoverCharge()
    {
        return $this->StopoverCharge;
    }
    /**
     * Set StopoverCharge value
     * @param \Sabre\OTAAirPrice\Structs\StopoverCharge $stopoverCharge
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public function setStopoverCharge(\Sabre\OTAAirPrice\Structs\StopoverCharge $stopoverCharge = null)
    {
        $this->StopoverCharge = $stopoverCharge;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\FareCalculationBreakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
