<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty Structs
 * @subpackage Structs
 */
class CustLoyalty extends AbstractStructBase
{
    /**
     * The ProgramID
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ProgramID;
    /**
     * The TierLevel
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $TierLevel;
    /**
     * Constructor method for CustLoyalty
     * @uses CustLoyalty::setProgramID()
     * @uses CustLoyalty::setTierLevel()
     * @param string $programID
     * @param string $tierLevel
     */
    public function __construct($programID = null, $tierLevel = null)
    {
        $this
            ->setProgramID($programID)
            ->setTierLevel($tierLevel);
    }
    /**
     * Get ProgramID value
     * @return string
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \Sabre\OTAAirPrice\Structs\CustLoyalty
     */
    public function setProgramID($programID = null)
    {
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get TierLevel value
     * @return string
     */
    public function getTierLevel()
    {
        return $this->TierLevel;
    }
    /**
     * Set TierLevel value
     * @param string $tierLevel
     * @return \Sabre\OTAAirPrice\Structs\CustLoyalty
     */
    public function setTierLevel($tierLevel = null)
    {
        $this->TierLevel = $tierLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\CustLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
