<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Corporate Structs
 * @subpackage Structs
 */
class Corporate extends AbstractStructBase
{
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * @var string[]
     */
    public $ID;
    /**
     * The Force
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Force;
    /**
     * Constructor method for Corporate
     * @uses Corporate::setID()
     * @uses Corporate::setForce()
     * @param string[] $iD
     * @param string $force
     */
    public function __construct(array $iD = array(), $force = null)
    {
        $this
            ->setID($iD)
            ->setForce($force);
    }
    /**
     * Get ID value
     * @return string[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param string[] $iD
     * @return \Sabre\OTAAirPrice\Structs\Corporate
     */
    public function setID(array $iD = array())
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\OTAAirPrice\Structs\Corporate
     */
    public function addToID($item)
    {
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Force value
     * @return string|null
     */
    public function getForce()
    {
        return $this->Force;
    }
    /**
     * Set Force value
     * @param string $force
     * @return \Sabre\OTAAirPrice\Structs\Corporate
     */
    public function setForce($force = null)
    {
        $this->Force = $force;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\Corporate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
