<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commission Structs
 * @subpackage Structs
 */
class Commission extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * The CapAmountInd
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CapAmountInd;
    /**
     * Constructor method for Commission
     * @uses Commission::setAmount()
     * @uses Commission::setPercent()
     * @uses Commission::setCapAmountInd()
     * @param string $amount
     * @param string $percent
     * @param string $capAmountInd
     */
    public function __construct($amount = null, $percent = null, $capAmountInd = null)
    {
        $this
            ->setAmount($amount)
            ->setPercent($percent)
            ->setCapAmountInd($capAmountInd);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\OTAAirPrice\Structs\Commission
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\OTAAirPrice\Structs\Commission
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get CapAmountInd value
     * @return string|null
     */
    public function getCapAmountInd()
    {
        return $this->CapAmountInd;
    }
    /**
     * Set CapAmountInd value
     * @param string $capAmountInd
     * @return \Sabre\OTAAirPrice\Structs\Commission
     */
    public function setCapAmountInd($capAmountInd = null)
    {
        $this->CapAmountInd = $capAmountInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\Commission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
