<?php

namespace Sabre\OTAAirPrice\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Branch Structs
 * @subpackage Structs
 */
class Branch extends AbstractStructBase
{
    /**
     * The PCC
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PCC;
    /**
     * The CountryOfShipRegistry
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CountryOfShipRegistry;
    /**
     * The FirstJointCarrier
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FirstJointCarrier;
    /**
     * The SecondJointCarrier
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SecondJointCarrier;
    /**
     * The IATAAuthorizedCarrier
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $IATAAuthorizedCarrier;
    /**
     * Constructor method for Branch
     * @uses Branch::setPCC()
     * @uses Branch::setCountryOfShipRegistry()
     * @uses Branch::setFirstJointCarrier()
     * @uses Branch::setSecondJointCarrier()
     * @uses Branch::setIATAAuthorizedCarrier()
     * @param string $pCC
     * @param string $countryOfShipRegistry
     * @param string $firstJointCarrier
     * @param string $secondJointCarrier
     * @param string $iATAAuthorizedCarrier
     */
    public function __construct($pCC = null, $countryOfShipRegistry = null, $firstJointCarrier = null, $secondJointCarrier = null, $iATAAuthorizedCarrier = null)
    {
        $this
            ->setPCC($pCC)
            ->setCountryOfShipRegistry($countryOfShipRegistry)
            ->setFirstJointCarrier($firstJointCarrier)
            ->setSecondJointCarrier($secondJointCarrier)
            ->setIATAAuthorizedCarrier($iATAAuthorizedCarrier);
    }
    /**
     * Get PCC value
     * @return string|null
     */
    public function getPCC()
    {
        return $this->PCC;
    }
    /**
     * Set PCC value
     * @param string $pCC
     * @return \Sabre\OTAAirPrice\Structs\Branch
     */
    public function setPCC($pCC = null)
    {
        $this->PCC = $pCC;
        return $this;
    }
    /**
     * Get CountryOfShipRegistry value
     * @return string|null
     */
    public function getCountryOfShipRegistry()
    {
        return $this->CountryOfShipRegistry;
    }
    /**
     * Set CountryOfShipRegistry value
     * @param string $countryOfShipRegistry
     * @return \Sabre\OTAAirPrice\Structs\Branch
     */
    public function setCountryOfShipRegistry($countryOfShipRegistry = null)
    {
        $this->CountryOfShipRegistry = $countryOfShipRegistry;
        return $this;
    }
    /**
     * Get FirstJointCarrier value
     * @return string|null
     */
    public function getFirstJointCarrier()
    {
        return $this->FirstJointCarrier;
    }
    /**
     * Set FirstJointCarrier value
     * @param string $firstJointCarrier
     * @return \Sabre\OTAAirPrice\Structs\Branch
     */
    public function setFirstJointCarrier($firstJointCarrier = null)
    {
        $this->FirstJointCarrier = $firstJointCarrier;
        return $this;
    }
    /**
     * Get SecondJointCarrier value
     * @return string|null
     */
    public function getSecondJointCarrier()
    {
        return $this->SecondJointCarrier;
    }
    /**
     * Set SecondJointCarrier value
     * @param string $secondJointCarrier
     * @return \Sabre\OTAAirPrice\Structs\Branch
     */
    public function setSecondJointCarrier($secondJointCarrier = null)
    {
        $this->SecondJointCarrier = $secondJointCarrier;
        return $this;
    }
    /**
     * Get IATAAuthorizedCarrier value
     * @return string|null
     */
    public function getIATAAuthorizedCarrier()
    {
        return $this->IATAAuthorizedCarrier;
    }
    /**
     * Set IATAAuthorizedCarrier value
     * @param string $iATAAuthorizedCarrier
     * @return \Sabre\OTAAirPrice\Structs\Branch
     */
    public function setIATAAuthorizedCarrier($iATAAuthorizedCarrier = null)
    {
        $this->IATAAuthorizedCarrier = $iATAAuthorizedCarrier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\OTAAirPrice\Structs\Branch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
